/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WizardAbilities {
    public static void passiveWizardSpellEcho(class_1657 player, List<class_1297> targets) {
        class_1297 target = targets.get(player.method_6051().method_43048(targets.size()));
        int chance = SimplySkills.wizardConfig.passiveWizardSpellEchoChance;
        if (player.method_6051().method_43048(100) < chance) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("simplyskills:frost_arrow");
            list.add("simplyskills:fire_arrow");
            list.add("simplyskills:lightning_arrow");
            list.add("simplyskills:arcane_bolt_lesser");
            list.add("simplyskills:ice_comet");
            list.add("simplyskills:fire_meteor");
            list.add("simplyskills:static_discharge");
            int spellChoice = player.method_6051().method_43048(list.size());
            SignatureAbilities.castSpellEngineIndirectTarget(player, (String)list.get(spellChoice), 120, target);
        }
    }

    public static boolean signatureWizardMeteorShower(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int meteoricWrathDuration = SimplySkills.wizardConfig.signatureWizardMeteoricWrathDuration;
        int meteoricWrathStacks = SimplySkills.wizardConfig.signatureWizardMeteoricWrathStacks - 1;
        int meteorShowerRange = SimplySkills.wizardConfig.signatureWizardMeteorShowerRange;
        if (HelperMethods.getTargetedEntity((class_1297)player, meteorShowerRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, meteorShowerRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, meteorShowerRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 8);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShowerWrath, (class_1309)player)) {
                    player.method_6092(new class_1293(EffectRegistry.METEORICWRATH, meteoricWrathDuration, meteoricWrathStacks));
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShowerGreater, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_meteor_large", 8, (class_1297)le);
                    continue;
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_meteor", 8, (class_1297)le);
            }
        }
        return success;
    }

    public static boolean signatureWizardIceComet(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int leapVelocity = SimplySkills.wizardConfig.signatureWizardIceCometLeapVelocity;
        double leapHeight = SimplySkills.wizardConfig.signatureWizardIceCometLeapHeight;
        int leapSlowfallDuration = SimplySkills.wizardConfig.signatureWizardIceCometLeapSlowfallDuration;
        int volleyDuration = SimplySkills.wizardConfig.signatureWizardIceCometVolleyDuration;
        int volleyStacks = SimplySkills.wizardConfig.signatureWizardIceCometVolleyStacks;
        int iceCometRange = SimplySkills.wizardConfig.signatureWizardIceCometRange;
        if (HelperMethods.getTargetedEntity((class_1297)player, iceCometRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, iceCometRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, iceCometRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometLeap, (class_1309)player)) {
                    player.method_18799(player.method_5720().method_22882().method_1021((double)leapVelocity));
                    player.method_18800(player.method_18798().field_1352, leapHeight, player.method_18798().field_1350);
                    player.method_6092(new class_1293(class_1294.field_5906, leapSlowfallDuration));
                    player.field_6037 = true;
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometVolley, (class_1309)player)) {
                    player.method_6092(new class_1293(EffectRegistry.FROSTVOLLEY, volleyDuration, volleyStacks));
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageOne, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large", 3, (class_1297)le);
                    continue;
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageTwo, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large_two", 3, (class_1297)le);
                    continue;
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageThree, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large_three", 3, (class_1297)le);
                    continue;
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet", 3, (class_1297)le);
            }
        }
        return success;
    }

    public static boolean signatureWizardStaticDischarge(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int amplifier = SimplySkills.wizardConfig.signatureWizardStaticDischargeBaseLeaps;
        int speedChance = SimplySkills.wizardConfig.signatureWizardStaticDischargeBaseSpeedChance;
        int speedChancePerTier = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedChancePerTier;
        int leapsPerTier = SimplySkills.wizardConfig.signatureWizardStaticDischargeLeapsPerTier;
        int staticDischargeRange = SimplySkills.wizardConfig.signatureWizardStaticDischargeRange;
        int staticChargeDuration = SimplySkills.wizardConfig.signatureWizardStaticChargeDuration;
        int dischargeSpeedDuration = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedDuration;
        int staticDischargeSpeedStacks = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedStacks;
        int staticDischargeSpeedMaxAmplifier = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedMaxAmplifier;
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeapTwo, (class_1309)player)) {
            amplifier += leapsPerTier;
        } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeapThree, (class_1309)player)) {
            amplifier += leapsPerTier * 2;
        }
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeSpeedTwo, (class_1309)player)) {
            speedChance += speedChancePerTier;
        } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeSpeedThree, (class_1309)player)) {
            speedChance += speedChancePerTier * 2;
        }
        if (HelperMethods.getTargetedEntity((class_1297)player, staticDischargeRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, staticDischargeRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, staticDischargeRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:static_discharge", 3, (class_1297)le);
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeap, (class_1309)player)) {
                    le.method_6092(new class_1293(EffectRegistry.STATICCHARGE, staticChargeDuration, amplifier));
                }
                if (!HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeSpeed, (class_1309)player) || player.method_6051().method_43048(100) >= speedChance) break;
                HelperMethods.incrementStatusEffect((class_1309)player, class_1294.field_5904, dischargeSpeedDuration, staticDischargeSpeedStacks, staticDischargeSpeedMaxAmplifier);
                break;
            }
        }
        return success;
    }

    public static boolean signatureWizardArcaneBolt(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int volleyDuration = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyDuration;
        int volleyStacks = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyStacks - 1;
        int arcaneBoltRange = SimplySkills.wizardConfig.signatureWizardArcaneBoltRange;
        int radius = 3;
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltLesser, (class_1309)player)) {
            radius = SimplySkills.wizardConfig.signatureWizardLesserArcaneBoltRadius;
        }
        if (HelperMethods.getTargetedEntity((class_1297)player, arcaneBoltRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, arcaneBoltRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, arcaneBoltRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, radius);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltVolley, (class_1309)player)) {
                    player.method_6092(new class_1293(EffectRegistry.ARCANEVOLLEY, volleyDuration, volleyStacks));
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltLesser, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt_lesser", radius, (class_1297)le);
                    continue;
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltGreater, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt_greater", radius, (class_1297)le);
                    break;
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt", radius, (class_1297)le);
                break;
            }
        }
        return success;
    }
}

