/*
 * Decompiled with CFR 0.152.
 */
package com.helliongames.snifferplus.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class StonePineBoatRenderer
extends EntityRenderer<Boat> {
    private static final ResourceLocation BOAT_TEXTURE = new ResourceLocation("snifferplus", "textures/entity/boat/stone_pine.png");
    private static final ResourceLocation CHEST_BOAT_TEXTURE = new ResourceLocation("snifferplus", "textures/entity/chest_boat/stone_pine.png");
    private final boolean hasChest;
    private ListModel<Boat> boatModel;

    public StonePineBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.hasChest = hasChest;
        this.boatModel = this.createBoatModel(context, Boat.Type.OAK, hasChest);
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, Boat.Type type, boolean bl) {
        ModelLayerLocation modelLayerLocation = bl ? ModelLayers.m_233550_((Boat.Type)type) : ModelLayers.m_171289_((Boat.Type)type);
        ModelPart modelPart = context.m_174023_(modelLayerLocation);
        return bl ? new ChestBoatModel(modelPart) : new BoatModel(modelPart);
    }

    public void render(Boat boat, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
        float h = (float)boat.m_38385_() - g;
        float j = boat.m_38384_() - g;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)boat.m_38352_(g), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.boatModel.m_6973_((Entity)boat, g, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(this.boatModel.m_103119_(this.hasChest ? CHEST_BOAT_TEXTURE : BOAT_TEXTURE));
        this.boatModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexConsumer2 = multiBufferSource.m_6299_(RenderType.m_110478_());
            ListModel<Boat> listModel = this.boatModel;
            if (listModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                waterPatchModel.m_102282_().m_104301_(poseStack, vertexConsumer2, i, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)boat, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(Boat boat) {
        return this.hasChest ? CHEST_BOAT_TEXTURE : BOAT_TEXTURE;
    }
}

