/*
 * Decompiled with CFR 0.152.
 */
package com.helliongames.snifferplus.mixin;

import com.google.common.collect.ImmutableList;
import com.helliongames.snifferplus.access.ServerPlayerAccess;
import com.helliongames.snifferplus.access.SnifferAccess;
import com.helliongames.snifferplus.registration.SnifferPlusMemoryModules;
import com.helliongames.snifferplus.world.SnifferContainer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sniffer.class})
public abstract class MixinSniffer
extends LivingEntity
implements SnifferAccess,
ContainerListener,
HasCustomInventoryScreen,
Saddleable {
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> f_271498_;
    protected SnifferContainer inventory;
    private static final EntityDataAccessor<Boolean> HAS_CHEST;
    private static final EntityDataAccessor<Boolean> HAS_SCENT_ITEM;
    private static final EntityDataAccessor<Boolean> IS_SADDLED;
    private static final List<SensorType<? extends Sensor<? super Sniffer>>> SENSOR_TYPES;
    private static final List<MemoryModuleType<?>> MEMORY_TYPES;

    @Shadow
    protected abstract Vec3 m_284388_();

    @Shadow
    protected abstract BlockPos m_284345_();

    @Shadow
    protected abstract Sniffer.State m_271917_();

    protected MixinSniffer(EntityType<? extends LivingEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void snifferplus_createDataAndInventoryOnCreation(EntityType type, Level level, CallbackInfo ci) {
        this.f_19804_.m_135372_(HAS_CHEST, (Object)false);
        this.f_19804_.m_135372_(HAS_SCENT_ITEM, (Object)false);
        this.f_19804_.m_135372_(IS_SADDLED, (Object)false);
        this.createInventory();
    }

    @Inject(method={"mobInteract"}, at={@At(value="RETURN")}, cancellable=true)
    private void snifferplus_addInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_36341_()) {
            this.m_213583_(player);
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
        } else if (!itemStack.m_41619_()) {
            if (!this.hasChest() && itemStack.m_150930_(Items.f_42009_)) {
                this.equipChest(player, itemStack);
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
            }
        } else if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    @Inject(method={"dropSeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void snifferplus_putSeedsInInventory(CallbackInfo ci) {
        if (this.m_9236_().m_5776_() || (Integer)this.f_19804_.m_135370_(f_271498_) != this.f_19797_) {
            return;
        }
        if (this.hasChest()) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_283841_);
            LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.m_284388_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList list = lootTable.m_287195_(lootParams);
            BlockPos blockPos = this.m_284345_();
            for (ItemStack itemStack : list) {
                ItemStack remainingStack = this.inventory.m_19173_(itemStack);
                if (remainingStack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), remainingStack);
                itemEntity.m_32060_();
                serverLevel.m_7967_((Entity)itemEntity);
            }
            this.m_5496_(SoundEvents.f_271330_, 1.0f, 1.0f);
            ci.cancel();
        }
    }

    @Inject(method={"brainProvider"}, at={@At(value="HEAD")}, cancellable=true)
    private void snifferplus_replaceBrainProvider(CallbackInfoReturnable<Brain.Provider<Sniffer>> cir) {
        cir.setReturnValue((Object)Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES));
    }

    @Inject(method={"getPassengersRidingOffset"}, at={@At(value="HEAD")}, cancellable=true)
    private void snifferplus_getRidingOffsetDigging(CallbackInfoReturnable<Double> cir) {
        if (this.m_271917_().equals((Object)Sniffer.State.DIGGING)) {
            cir.setReturnValue((Object)1.3);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.m_20160_() && this.m_6254_() && !this.hasScentItem();
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (this.hasScentItem()) {
            return null;
        }
        Entity firstPassenger = this.m_146895_();
        if (firstPassenger instanceof Mob) {
            return (Mob)firstPassenger;
        }
        if (this.m_6254_() && firstPassenger instanceof Player) {
            return (Player)firstPassenger;
        }
        return null;
    }

    protected void m_274498_(Player $$0, Vec3 $$1) {
        super.m_274498_($$0, $$1);
        if (!this.hasScentItem()) {
            Vec2 $$2 = this.getRiddenRotation((LivingEntity)$$0);
            this.m_19915_($$2.f_82471_, $$2.f_82470_);
            this.f_20883_ = this.f_20885_ = this.m_146908_();
            this.f_19859_ = this.f_20885_;
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity rider) {
        return new Vec2(rider.m_146909_() * 0.5f, rider.m_146908_());
    }

    protected Vec3 m_274312_(Player player, Vec3 movement) {
        if (!this.hasScentItem()) {
            float xAccel = player.f_20900_ * 0.5f;
            float zAccel = player.f_20902_;
            if (zAccel <= 0.0f) {
                zAccel *= 0.25f;
            }
            float yAccel = this.m_20069_() ? 0.5f : 0.0f;
            return new Vec3((double)xAccel, (double)yAccel, (double)zAccel);
        }
        return movement;
    }

    protected float m_245547_(Player player) {
        if (this.hasScentItem()) {
            return (float)this.m_21133_(Attributes.f_22279_);
        }
        float speedFactor = this.m_20069_() ? 0.75f : 0.5f;
        return (float)this.m_21133_(Attributes.f_22279_) * speedFactor;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            tag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            tag.m_128365_("ScentItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        tag.m_128379_("Chested", this.hasChest());
        if (this.hasChest()) {
            ListTag $$1 = new ListTag();
            for (int $$2 = 2; $$2 < this.inventory.m_6643_(); ++$$2) {
                ItemStack $$3 = this.inventory.m_8020_($$2);
                if ($$3.m_41619_()) continue;
                CompoundTag $$4 = new CompoundTag();
                $$4.m_128344_("Slot", (byte)$$2);
                $$3.m_41739_($$4);
                $$1.add((Object)$$4);
            }
            tag.m_128365_("Items", (Tag)$$1);
        }
    }

    public void m_7378_(CompoundTag tag) {
        ItemStack $$4;
        super.m_7378_(tag);
        if (tag.m_128425_("SaddleItem", 10) && ($$4 = ItemStack.m_41712_((CompoundTag)tag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, $$4);
        }
        if (tag.m_128425_("ScentItem", 10)) {
            ItemStack scentItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ScentItem"));
            this.inventory.m_6836_(1, scentItem);
        }
        this.setChest(tag.m_128471_("Chested"));
        this.createInventory();
        if (this.hasChest()) {
            ListTag $$1 = tag.m_128437_("Items", 10);
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                CompoundTag $$3 = $$1.m_128728_($$2);
                int $$42 = $$3.m_128445_("Slot") & 0xFF;
                if ($$42 < 2 || $$42 >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_($$42, ItemStack.m_41712_((CompoundTag)$$3));
            }
        }
        this.updateContainerEquipment();
    }

    public void m_213583_(Player player) {
        if (!(this.m_9236_().f_46443_ || this.m_20160_() && !this.m_20363_((Entity)player))) {
            ((ServerPlayerAccess)player).openSnifferInventory((Sniffer)this, (Container)this.inventory);
        }
    }

    public SlotAccess m_141942_(int $$0) {
        if ($$0 == 499) {
            return new SlotAccess(){

                public ItemStack m_142196_() {
                    return MixinSniffer.this.hasChest() ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.f_41583_;
                }

                public boolean m_142104_(ItemStack $$0) {
                    if ($$0.m_41619_()) {
                        if (MixinSniffer.this.hasChest()) {
                            MixinSniffer.this.setChest(false);
                            MixinSniffer.this.createInventory();
                        }
                        return true;
                    }
                    if ($$0.m_150930_(Items.f_42009_)) {
                        if (!MixinSniffer.this.hasChest()) {
                            MixinSniffer.this.setChest(true);
                            MixinSniffer.this.createInventory();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        int $$1 = $$0 - 400;
        if ($$1 >= 0 && $$1 < 2 && $$1 < this.inventory.m_6643_()) {
            if ($$1 == 0) {
                return this.createEquipmentSlotAccess($$1, $$0x -> $$0x.m_41619_() || $$0x.m_150930_(Items.f_42450_));
            }
            return SlotAccess.f_147290_;
        }
        int $$2 = $$0 - 500 + 2;
        return $$2 >= 2 && $$2 < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)$$2) : super.m_141942_($$0);
    }

    private SlotAccess createEquipmentSlotAccess(final int $$0, final Predicate<ItemStack> $$1) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return MixinSniffer.this.inventory.m_8020_($$0);
            }

            public boolean m_142104_(ItemStack $$0x) {
                if (!$$1.test($$0x)) {
                    return false;
                }
                MixinSniffer.this.inventory.m_6836_($$0, $$0x);
                MixinSniffer.this.updateContainerEquipment();
                return true;
            }
        };
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack stack = this.inventory.m_8020_(i);
                if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack)) continue;
                this.m_19983_(stack);
            }
        }
        if (this.hasChest()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setChest(false);
        }
    }

    @Override
    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CHEST);
    }

    private void setChest(boolean hasChest) {
        this.f_19804_.m_135381_(HAS_CHEST, (Object)hasChest);
    }

    @Override
    public boolean hasScentItem() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SCENT_ITEM);
    }

    private void setScentItem(boolean hasScentItem) {
        this.f_19804_.m_135381_(HAS_SCENT_ITEM, (Object)hasScentItem);
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SADDLED);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(IS_SADDLED, (Object)(!this.inventory.m_8020_(0).m_41619_() ? 1 : 0));
            this.setScentItem(!this.inventory.m_8020_(1).m_41619_());
        }
    }

    public void m_5757_(Container var1) {
        boolean saddled = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !saddled && this.m_6254_()) {
            this.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    private void equipChest(Player player, ItemStack itemStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.createInventory();
    }

    public void m_5853_(@Nullable SoundSource source) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    protected void playChestEquipsSound() {
        this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    protected int getInventorySize() {
        return this.hasChest() ? 38 : 2;
    }

    @Override
    public int getInventoryColumns() {
        return 9;
    }

    protected void createInventory() {
        SnifferContainer snifferContainer = this.inventory;
        this.inventory = new SnifferContainer(this.getInventorySize());
        if (snifferContainer != null) {
            snifferContainer.m_19181_(this);
            int i = Math.min(snifferContainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemStack = snifferContainer.m_8020_(j);
                if (itemStack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemStack.m_41777_());
            }
        }
        this.inventory.m_19164_(this);
        this.updateContainerEquipment();
    }

    static {
        HAS_CHEST = SynchedEntityData.m_135353_(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        HAS_SCENT_ITEM = SynchedEntityData.m_135353_(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_SADDLED = SynchedEntityData.m_135353_(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_26812_, (Object)SensorType.f_278390_);
        MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, SnifferPlusMemoryModules.OUTPOST_LOCATION.get(), (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_271134_, (Object)MemoryModuleType.f_271280_, (Object)MemoryModuleType.f_271087_, (Object)MemoryModuleType.f_217772_, (Object)MemoryModuleType.f_271415_, (Object)MemoryModuleType.f_148205_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26375_, MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_});
    }
}

