/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.waterphysics.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class Utils {
    public static BlockPos getWorldPos(LevelChunk chunk, LevelChunkSection section, BlockPos relativePos) {
        return new BlockPos(chunk.m_7697_().m_45604_() + relativePos.m_123341_(), section.m_63017_() + relativePos.m_123342_(), chunk.m_7697_().m_45605_() + relativePos.m_123343_());
    }

    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return Utils.isChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.m_7726_() instanceof ServerChunkCache) {
            ChunkHolder holder = (ChunkHolder)((ServerChunkCache)world.m_7726_()).f_8325_.f_140130_.get(ChunkPos.m_45589_((int)x, (int)z));
            if (holder != null) {
                return holder.m_140082_().getNow(ChunkHolder.f_139997_).left().isPresent();
            }
            return false;
        }
        return world.m_6522_(x, z, ChunkStatus.f_62326_, false) != null;
    }

    public static BlockState getBlockState(LevelChunk chunk, BlockPos pos, int sectionId) {
        if (pos.m_123341_() >= 16 || pos.m_123343_() >= 16 || pos.m_123341_() < 0 || pos.m_123343_() < 0) {
            BlockPos worldPos = Utils.getWorldPos(chunk, chunk.m_7103_()[sectionId], pos);
            if (Utils.isBlockLoaded((LevelAccessor)chunk.m_62953_(), worldPos)) {
                return chunk.m_62953_().m_8055_(worldPos);
            }
            return Blocks.f_50375_.m_49966_();
        }
        if (pos.m_123342_() < 0) {
            int sectionDif;
            if (sectionId > 0 && sectionId + (sectionDif = (int)Math.floor((double)pos.m_123342_() / 16.0)) >= 0) {
                return chunk.m_7103_()[sectionId + sectionDif].m_62982_(pos.m_123341_(), sectionDif * -1 * 16 + pos.m_123342_(), pos.m_123343_());
            }
            return Blocks.f_50375_.m_49966_();
        }
        if (pos.m_123342_() >= 16) {
            int sectionDif;
            if (sectionId + 1 < chunk.m_7103_().length && (sectionDif = (int)((double)pos.m_123342_() / 16.0)) + sectionId < chunk.m_7103_().length) {
                return chunk.m_7103_()[sectionId + sectionDif].m_62982_(pos.m_123341_(), pos.m_123342_() - sectionDif * 16, pos.m_123343_());
            }
            return Blocks.f_50375_.m_49966_();
        }
        return chunk.m_7103_()[sectionId].m_62982_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static boolean tryMoveBelow(Level level, BlockPos pos, boolean allowAir) {
        BlockState state = level.m_8055_(pos.m_7495_());
        if (Utils.canMoveSourceIntoState(state, allowAir)) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            level.m_7731_(pos.m_7495_(), Blocks.f_49990_.m_49966_(), 3);
            return true;
        }
        return false;
    }

    public static boolean tryMoveSidewards(Level level, BlockPos pos, boolean allowAir) {
        BlockState initialAboveState = level.m_8055_(pos.m_7494_());
        if (initialAboveState.m_60734_() != Blocks.f_49990_ || !initialAboveState.m_60819_().m_76170_()) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = level.m_8055_(pos.m_121945_(direction));
            BlockState aboveState = level.m_8055_(pos.m_121945_(direction).m_7494_());
            if (!Utils.canMoveSourceIntoState(state, allowAir) || !Utils.canMoveSourceIntoState(aboveState, allowAir)) continue;
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            level.m_7731_(pos.m_121945_(direction), Blocks.f_49990_.m_49966_(), 3);
            return true;
        }
        return false;
    }

    public static void tryMoveDiagonally(Level level, BlockPos pos, boolean allowAir) {
        BlockState initialAboveState = level.m_8055_(pos.m_7494_());
        if (initialAboveState.m_60767_().m_76333_()) {
            return;
        }
        for (int i = 2; i <= 7; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                boolean canMove = true;
                for (int j = 1; j < i; ++j) {
                    BlockState dirState = level.m_8055_(pos.m_5484_(direction, j));
                    if (Utils.canMoveSourceIntoState(dirState, allowAir)) continue;
                    canMove = false;
                }
                if (!canMove) continue;
                BlockState state = level.m_8055_(pos.m_5484_(direction, i).m_7495_());
                BlockState aboveState = level.m_8055_(pos.m_5484_(direction, i));
                if (!Utils.canMoveSourceIntoState(state, allowAir) || !Utils.canMoveSourceIntoState(aboveState, true)) continue;
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(pos.m_5484_(direction, i).m_7495_(), Blocks.f_49990_.m_49966_(), 3);
                return;
            }
        }
        BlockPos progressPos = Utils.getBlockInRandomDirection(pos, level.m_213780_());
        for (int i = 0; i < level.m_213780_().m_188503_(10); ++i) {
            BlockState state = level.m_8055_(progressPos.m_7495_());
            BlockState aboveState = level.m_8055_(progressPos);
            if (!Utils.canMoveSourceIntoState(aboveState, false)) continue;
            if (Utils.canMoveSourceIntoState(state, allowAir)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(progressPos.m_7495_(), Blocks.f_49990_.m_49966_(), 3);
                return;
            }
            progressPos = Utils.getBlockInRandomDirection(progressPos, level.m_213780_());
        }
    }

    public static BlockPos getBlockInRandomDirection(BlockPos pos, RandomSource random) {
        return pos.m_121945_(Direction.Plane.HORIZONTAL.m_235690_(random));
    }

    public static boolean canMoveSourceIntoState(BlockState state, boolean allowAir) {
        return allowAir && state.m_60795_() || state.m_60734_() == Blocks.f_49990_ && !state.m_60819_().m_76170_();
    }
}

