/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.data;

import com.google.common.collect.Lists;
import fuzs.arcanelanterns.init.ModRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

class LanternMakingRecipeBuilder
extends ShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public LanternMakingRecipeBuilder(ItemLike result, int count) {
        super(result, count);
        this.result = result.m_5456_();
        this.count = count;
    }

    public static LanternMakingRecipeBuilder recipe(ItemLike result) {
        return new LanternMakingRecipeBuilder(result, 1);
    }

    public static LanternMakingRecipeBuilder recipe(ItemLike result, int count) {
        return new LanternMakingRecipeBuilder(result, count);
    }

    public ShapelessRecipeBuilder m_126186_(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public ShapelessRecipeBuilder m_126145_(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept((FinishedRecipe)new Result(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(recipeId.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + recipeId.m_135815_())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    static class Result
    extends ShapelessRecipeBuilder.Result {
        public Result(ResourceLocation id, Item result, int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(id, result, count, group, ingredients, advancement, advancementId);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRegistry.LANTERN_MAKING_RECIPE_SERIALIZER.get();
        }
    }
}

