/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fuzs.arcanelanterns.init.ModRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class LanternMakingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    final String group;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;

    public LanternMakingRecipe(ResourceLocation resourceLocation, String string, ItemStack itemStack, NonNullList<Ingredient> nonNullList) {
        this.id = resourceLocation;
        this.group = string;
        this.result = itemStack;
        this.ingredients = nonNullList;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRegistry.LANTERN_MAKING_RECIPE_TYPE.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.LANTERN_MAKING_RECIPE_SERIALIZER.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_5818_(Container inv, Level level) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
            stackedContents.m_36468_(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.m_36475_((Recipe)this, (IntList)null);
    }

    public ItemStack m_5874_(Container inv) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<LanternMakingRecipe> {
        public LanternMakingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonNullList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new LanternMakingRecipe(recipeId, string, itemStack, nonNullList);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray ingredientArray) {
            NonNullList nonNullList = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public LanternMakingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            int i = buffer.m_130242_();
            NonNullList nonNullList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.m_130267_();
            return new LanternMakingRecipe(recipeId, string, itemStack, (NonNullList<Ingredient>)nonNullList);
        }

        public void toNetwork(FriendlyByteBuf buffer, LanternMakingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

