/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.mixin.accessor.LivingEntityAccessor;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BriliantLanternBlockEntity
extends LanternBlockEntity {
    public BriliantLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.BRILIANT_LANTERN_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BriliantLanternBlockEntity blockEntity) {
        ServerConfig.BriliantLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).briliantLantern;
        if (++blockEntity.count <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        List animals = level.m_6443_(Animal.class, new AABB((double)pos.m_123341_() + 0.5 - (double)horizontalRange, (double)pos.m_123342_() + 0.5 - (double)verticalRange, (double)pos.m_123343_() + 0.5 - (double)horizontalRange, (double)pos.m_123341_() + 0.5 + (double)horizontalRange, (double)pos.m_123342_() + 0.5 + (double)verticalRange, (double)pos.m_123343_() + 0.5 + (double)horizontalRange), BriliantLanternBlockEntity::isValidAnimal);
        if (!animals.isEmpty()) {
            Animal animal = (Animal)animals.get(0);
            BriliantLanternBlockEntity.killWithoutLoot(level, (LivingEntity)animal);
            animal.m_6598_(null);
            ((LivingEntityAccessor)animal).arcanelanterns$dropExperience();
        }
        blockEntity.count = 0;
    }

    private static boolean isValidAnimal(Animal animal) {
        TamableAnimal tamableAnimal;
        return animal.m_6149_() && (!(animal instanceof TamableAnimal) || !(tamableAnimal = (TamableAnimal)animal).m_21824_()) && !((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).briliantLantern.blacklist.contains((Object)animal.m_6095_());
    }

    private static void killWithoutLoot(Level level, LivingEntity entity) {
        boolean doMobLoot = level.m_46469_().m_46207_(GameRules.f_46135_);
        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46135_)).m_46246_(false, level.m_7654_());
        entity.m_6074_();
        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46135_)).m_46246_(doMobLoot, level.m_7654_());
    }
}

