/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FeralLanternBlockEntity
extends LanternBlockEntity {
    private static final String TAG_FLARES = "PlacedFlares";
    private int placedFlares;
    private boolean placeAttempt;

    public FeralLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FERAL_LANTERN_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FeralLanternBlockEntity blockEntity) {
        ServerConfig.FeralLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).feralLantern;
        if (++blockEntity.count > config.delay && !blockEntity.placeAttempt) {
            int horizontalRange = config.horizontalRange;
            int verticalRange = config.verticalRange;
            if (blockEntity.placedFlares >= config.maxPlacedFlares) {
                level.m_46961_(pos, false);
                return;
            }
            BlockPos check = pos.m_121996_(new Vec3i(horizontalRange, verticalRange, horizontalRange));
            check = check.m_7918_(level.f_46441_.m_188503_(horizontalRange * 2), -level.f_46441_.m_188503_(verticalRange * 2), level.f_46441_.m_188503_(horizontalRange * 2));
            while (check.m_123314_((Vec3i)pos, 200.0)) {
                blockEntity.placeAttempt = true;
                if (level.m_8055_(check).m_60795_() && !level.m_8055_(check.m_7495_()).m_60795_() && level.m_46803_(check) < config.maxLightLevel) {
                    level.m_46597_(check, ((Block)ModRegistry.SPARK_BLOCK.get()).m_49966_());
                    blockEntity.placeAttempt = false;
                    ++blockEntity.placedFlares;
                }
                check = check.m_121996_(new Vec3i(0, 1, 0));
            }
            if (!check.m_123314_((Vec3i)pos, 100.0)) {
                blockEntity.placeAttempt = false;
            }
            blockEntity.count = 0;
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_FLARES, this.placedFlares);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.placedFlares = tag.m_128451_(TAG_FLARES);
    }
}

