/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.networking.ClientboundCraftLanternParticlesMessage;
import fuzs.arcanelanterns.world.item.crafting.LanternMakingRecipe;
import fuzs.puzzleslib.util.ContainerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LanternMakerBlockEntity
extends BlockEntity
implements ContainerImpl {
    private final RecipeManager.CachedCheck<Container, LanternMakingRecipe> quickCheck;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);

    public LanternMakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.LANTERN_MAKER_BLOCK_ENTITY.get(), pos, state);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)ModRegistry.LANTERN_MAKING_RECIPE_TYPE.get()));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LanternMakerBlockEntity blockEntity) {
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        if (stateAbove.m_60713_(Blocks.f_50681_) || stateAbove.m_60713_(Blocks.f_50682_)) {
            ItemStack result = blockEntity.quickCheck.m_213657_((Container)blockEntity, level).map(recipe -> recipe.m_5874_((Container)blockEntity)).orElse(ItemStack.f_41583_);
            if (!result.m_41619_()) {
                for (ItemStack stack : blockEntity.items) {
                    if (stack.m_41619_()) continue;
                    stack.m_41774_(1);
                }
                blockEntity.m_6596_();
                level.m_46961_(posAbove, false);
                LanternMakerBlockEntity.dropItemStack(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, result);
                ArcaneLanterns.NETWORK.sendToAllNear((Record)new ClientboundCraftLanternParticlesMessage(pos), pos, level);
            } else {
                LanternMakerBlockEntity.destroyBlockDropCentered(level, stateAbove, posAbove);
            }
        }
    }

    private static void destroyBlockDropCentered(Level level, BlockState state, BlockPos pos) {
        BlockEntity blockEntityAbove = state.m_155947_() ? level.m_7702_(pos) : null;
        level.m_46961_(pos, false);
        Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)blockEntityAbove, null, (ItemStack)ItemStack.f_41583_).forEach(itemStack -> LanternMakerBlockEntity.dropItemStack(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, itemStack));
        state.m_222967_((ServerLevel)level, pos, ItemStack.f_41583_, true);
    }

    public static void dropItemStack(Level level, double posX, double posY, double posZ, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(level, posX, posY, posZ, stack);
        itemEntity.m_20256_(Vec3.f_82478_);
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    public NonNullList<ItemStack> items() {
        return this.items;
    }

    public int m_6893_() {
        return 1;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

