/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.networking.ClientboundWailingSoundsMessage;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class WailingLanternBlockEntity
extends LanternBlockEntity {
    public WailingLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.WAILING_LANTERN_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WailingLanternBlockEntity blockEntity) {
        ServerConfig.EffectLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).wailingLantern;
        if (++blockEntity.count <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        level.m_6443_(Player.class, new AABB((double)pos.m_123341_() + 0.5 - (double)horizontalRange, (double)pos.m_123342_() + 0.5 - (double)verticalRange, (double)pos.m_123343_() + 0.5 - (double)horizontalRange, (double)pos.m_123341_() + 0.5 + (double)horizontalRange, (double)pos.m_123342_() + 0.5 + (double)verticalRange, (double)pos.m_123343_() + 0.5 + (double)horizontalRange), EntitySelector.f_20406_).forEach(player -> {
            if (!player.m_20183_().m_123314_((Vec3i)pos, 5.0)) {
                ArcaneLanterns.NETWORK.sendToAllNear((Record)new ClientboundWailingSoundsMessage(pos, false), pos, level);
            } else {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, config.effectDuration * 20, 0));
                ArcaneLanterns.NETWORK.sendToAllNear((Record)new ClientboundWailingSoundsMessage(pos, true), pos, level);
            }
        });
        blockEntity.count = 0;
    }
}

