/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.arcanelanterns.world.level.block.entity.LanternMakerBlockEntity;
import java.util.function.Predicate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class LanternMakerRenderer
implements BlockEntityRenderer<LanternMakerBlockEntity> {
    private final ItemRenderer itemRenderer;

    public LanternMakerRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(LanternMakerBlockEntity blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        NonNullList<ItemStack> items = blockEntity.items();
        if (items.isEmpty()) {
            return;
        }
        int posData = (int)blockEntity.m_58899_().m_121878_();
        float totalTicks = (float)blockEntity.m_58904_().m_46467_() + tickDelta;
        long filledSlots = items.stream().filter(Predicate.not(ItemStack::m_41619_)).count();
        float itemRenderAngle = 360.0f / (float)filledSlots;
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).m_41619_()) continue;
            matrices.m_85836_();
            matrices.m_252880_(0.5f, 1.15f, 0.5f);
            matrices.m_252781_(Axis.f_252436_.m_252977_((float)i * itemRenderAngle + totalTicks));
            matrices.m_252880_(0.75f, 0.0f, 0.25f);
            matrices.m_252781_(Axis.f_252436_.m_252977_(totalTicks % 360.0f));
            matrices.m_85837_(0.0, 0.075 * Math.sin(((double)totalTicks + (double)i * 10.0) / 5.0), 0.0);
            this.itemRenderer.m_174269_((ItemStack)items.get(i), ItemTransforms.TransformType.GROUND, light, overlay, matrices, vertexConsumers, posData + i);
            matrices.m_85849_();
        }
    }
}

