/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.data;

import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.puzzleslib.api.data.v1.AbstractModelProvider;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModModelProvider
extends AbstractModelProvider {
    public ModModelProvider(PackOutput packOutput, String modId, ExistingFileHelper fileHelper) {
        super(packOutput, modId, fileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleExistingBlockWithItem((Block)ModRegistry.LANTERN_MAKER_BLOCK.get());
        this.simpleExistingBlock((Block)ModRegistry.SPARK_BLOCK.get());
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            Object v;
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("arcanelanterns") || !((v = entry.getValue()) instanceof LanternBlock)) continue;
            LanternBlock block = (LanternBlock)v;
            this.lanternBlock((Block)block);
        }
    }

    public void lanternBlock(Block block) {
        BlockModelBuilder lantern = this.lantern(this.name(block), this.blockTexture(block));
        BlockModelBuilder hangingLantern = this.hangingLantern("hanging_" + this.name(block), this.blockTexture(block));
        this.lanternBlock(block, (ModelFile)lantern, (ModelFile)hangingLantern);
        this.basicItem(block.m_5456_());
    }

    public void lanternBlock(Block block, ModelFile lantern, ModelFile hangingLantern) {
        this.getVariantBuilder(block).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(hangingLantern)}).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(lantern)});
    }

    public BlockModelBuilder lantern(String fileName, ResourceLocation texture) {
        return (BlockModelBuilder)this.models().singleTexture(fileName, this.mcLoc("block/template_lantern"), "lantern", texture);
    }

    public BlockModelBuilder hangingLantern(String fileName, ResourceLocation texture) {
        return (BlockModelBuilder)this.models().singleTexture(fileName, this.mcLoc("block/template_hanging_lantern"), "lantern", texture);
    }
}

