/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.network.ClientboundBorealParticlesMessage;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BorealLanternBlockEntity
extends LanternBlockEntity {
    public BorealLanternBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.BOREAL_LANTERN_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BorealLanternBlockEntity blockEntity) {
        ServerConfig.EffectLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).borealLantern;
        if (++blockEntity.count <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        level.m_6443_(LivingEntity.class, new AABB((double)pos.m_123341_() + 0.5 - (double)horizontalRange, (double)pos.m_123342_() + 0.5 - (double)verticalRange, (double)pos.m_123343_() + 0.5 - (double)horizontalRange, (double)pos.m_123341_() + 0.5 + (double)horizontalRange, (double)pos.m_123342_() + 0.5 + (double)verticalRange, (double)pos.m_123343_() + 0.5 + (double)horizontalRange), EntitySelector.f_20406_).forEach(entity -> {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, config.effectDuration * 20, 3));
            entity.m_7311_(0);
            ArcaneLanterns.NETWORK.sendToAllNear(entity.m_20183_(), level, (Record)new ClientboundBorealParticlesMessage(pos, entity.m_20183_()));
        });
        blockEntity.count = 0;
    }
}

