/*
 * Decompiled with CFR 0.152.
 */
package baguchan.armored_redstone.entity;

import baguchan.armored_redstone.ArmoredRedstone;
import baguchan.armored_redstone.message.FinishDushAttackMessage;
import baguchan.armored_redstone.message.StartDushAttackMessage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public abstract class BaseArmorEntity
extends PathfinderMob
implements PlayerRideableJumping {
    private static final UUID SPEED_MODIFIER_EXTRA_SPRINTING_UUID = UUID.fromString("d4c7a47d-709e-9722-a10c-91cc76449c88");
    private static final AttributeModifier SPEED_MODIFIER_EXTRA_SPRINTING = new AttributeModifier(SPEED_MODIFIER_EXTRA_SPRINTING_UUID, "Extra Sprinting speed boost", 1.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected boolean isJumping;
    protected float playerJumpPendingScale;
    private boolean allowStandSliding;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState attackFinishedAnimationState = new AnimationState();

    protected BaseArmorEntity(EntityType<? extends BaseArmorEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    public void m_6858_(boolean p_21284_) {
        super.m_6858_(p_21284_);
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (attributeinstance.m_22111_(SPEED_MODIFIER_EXTRA_SPRINTING_UUID) != null) {
            attributeinstance.m_22130_(SPEED_MODIFIER_EXTRA_SPRINTING);
        }
        if (p_21284_) {
            attributeinstance.m_22118_(SPEED_MODIFIER_EXTRA_SPRINTING);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
        if (f_19805_.equals(p_21104_)) {
            if (this.m_20142_()) {
                this.m_5496_(SoundEvents.f_12374_, 1.5f, 1.2f);
            } else {
                this.m_5496_(SoundEvents.f_12374_, 1.5f, 1.2f);
            }
        }
    }

    public boolean m_142535_(float p_149499_, float p_149500_, DamageSource p_149501_) {
        int i = this.m_5639_(p_149499_, p_149500_);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(p_149501_, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(p_149501_, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_) - 10;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.updateClientControls();
        }
        if (this.m_20142_()) {
            this.dash();
        }
        if (this.canStepUp()) {
            this.f_19793_ = this.m_20142_() ? 0.5f : 1.0f;
        }
    }

    private boolean isMoving() {
        return this.canDashWithWall() || this.m_20184_().m_165925_() > 0.0;
    }

    protected boolean canDashWithWall() {
        return false;
    }

    protected boolean canStepUp() {
        return true;
    }

    protected boolean canDush() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && this.m_20363_((Entity)mc.f_91074_)) {
            boolean flag6 = this.f_19862_;
            if (!this.m_20142_() && this.canDush() && mc.f_91066_.f_92091_.m_90857_() && mc.f_91066_.f_92085_.m_90857_() && this.isMoving() && this.m_20096_()) {
                this.dushStart();
            } else if (this.m_20142_() && !this.isMoving() && !mc.f_91066_.f_92091_.m_90857_()) {
                this.dushFinish();
            }
        } else if (this.m_20142_() && this.getControllingPassenger() == null) {
            this.dushFinish();
        }
    }

    protected void m_20076_() {
        super.m_20076_();
        EntityDimensions dimensions = this.m_6972_(this.m_20089_());
        Vec3 vec3 = this.m_20184_();
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)dimensions.f_20377_, this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)dimensions.f_20377_, vec3.f_82479_ * -0.25, 0.25, vec3.f_82481_ * -0.25);
    }

    private void dushFinish() {
        ArmoredRedstone.CHANNEL.sendToServer((Object)new FinishDushAttackMessage((Entity)this));
    }

    private void dushStart() {
        ArmoredRedstone.CHANNEL.sendToServer((Object)new StartDushAttackMessage((Entity)this));
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        super.m_7355_(p_20135_, p_20136_);
        if (!this.m_20142_() && this.stepSounds() != null) {
            this.m_5496_(this.stepSounds(), 1.0f, 1.0f);
        }
    }

    @Nullable
    public SoundEvent stepSounds() {
        return SoundEvents.f_12010_;
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.75;
    }

    public abstract void attack();

    public abstract void secondAttack();

    public AABB getAttackBoundingBox() {
        Vec3 vec3d = this.m_20252_(1.0f);
        return this.m_20191_().m_82310_(0.0, (double)(-(this.m_20206_() - this.m_20205_())), 0.0).m_82377_(1.0, 1.0, 1.0).m_82386_(vec3d.f_82479_ * 1.65, vec3d.f_82480_ * 1.65, vec3d.f_82481_ * 1.65);
    }

    private void dash() {
        for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_(0.75, 0.0, 0.75))) {
            if (entity == this || this.m_146895_() != null && (this.m_146895_() == null || entity == this.m_146895_()) || this.m_7307_(entity) || !entity.m_6097_() || !((double)this.m_20270_(entity) < 26.0) || !entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 7.0f)) continue;
            entity.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
            if (!(entity instanceof LivingEntity)) continue;
            double d1 = entity.m_20185_() - this.m_20185_();
            double d0 = entity.m_20189_() - this.m_20189_();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            ((LivingEntity)entity).m_147240_(1.0, d1, d0);
            if (!(this.m_146895_() instanceof Player)) continue;
            ((LivingEntity)entity).m_6598_((Player)this.m_146895_());
        }
    }

    public void m_7023_(Vec3 p_30633_) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.m_20160_() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.35f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.f_19861_) {
                    double d0 = 1.1 * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, p_30633_.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.f_19861_ || this.m_5825_() && this.canJumpOnLava() && this.isInFluidType((FluidType)ForgeMod.LAVA_TYPE.get())) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(p_30633_);
            }
        }
    }

    public boolean canJumpOnLava() {
        return false;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public InteractionResult m_6071_(Player p_30713_, InteractionHand p_30714_) {
        ItemStack itemstack = p_30713_.m_21120_(p_30714_);
        if (this.m_6162_()) {
            return super.m_6071_(p_30713_, p_30714_);
        }
        if (this.m_21223_() < this.m_21233_() && this.healItem(itemstack)) {
            this.m_5634_(20.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        this.doPlayerRide(p_30713_);
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean healItem(ItemStack itemstack) {
        return itemstack.m_150930_(Items.f_42416_);
    }

    protected void doPlayerRide(Player p_30634_) {
        if (!this.f_19853_.f_46443_) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_((Entity)this);
        }
    }

    public void m_7888_(int p_30591_) {
        if (p_30591_ < 0) {
            p_30591_ = 0;
        } else {
            this.allowStandSliding = true;
            this.stand();
        }
        this.playerJumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
    }

    private void stand() {
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    public boolean m_7132_(Player p_260002_) {
        return true;
    }

    public void m_7199_(int p_21695_) {
        this.allowStandSliding = true;
        this.stand();
        this.m_5496_(SoundEvents.f_12374_, 1.5f, 1.2f);
    }

    public void m_8012_() {
    }

    public boolean m_6146_() {
        return true;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() == MobEffects.f_19615_ || p_34192_.m_19544_() == MobEffects.f_19614_ ? false : super.m_7301_(p_34192_);
    }

    public float hurtRider(DamageSource damageSource, float damage) {
        if (damageSource.m_19372_()) {
            return damage * 0.95f;
        }
        return damage;
    }

    public boolean m_7327_(Entity p_21372_) {
        if (p_21372_ instanceof LivingEntity && this.m_146895_() instanceof Player) {
            ((LivingEntity)p_21372_).m_6598_((Player)this.m_146895_());
        }
        return super.m_7327_(p_21372_);
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }
}

