/*
 * Decompiled with CFR 0.152.
 */
package baguchan.armored_redstone.entity;

import baguchan.armored_redstone.register.ModItems;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidType;

public abstract class BaseArmorEntity
extends PathfinderMob
implements PlayerRideableJumping {
    private static final UUID SPEED_MODIFIER_EXTRA_SPRINTING_UUID = UUID.fromString("d4c7a47d-709e-9722-a10c-91cc76449c88");
    private static final AttributeModifier SPEED_MODIFIER_EXTRA_SPRINTING = new AttributeModifier(SPEED_MODIFIER_EXTRA_SPRINTING_UUID, "Extra Sprinting speed boost", 1.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected boolean isJumping;
    protected float playerJumpPendingScale;
    private boolean allowStandSliding;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState attackFinishedAnimationState = new AnimationState();

    protected BaseArmorEntity(EntityType<? extends BaseArmorEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    public void m_6858_(boolean p_21284_) {
        super.m_6858_(p_21284_);
        if (this.hasSprintUnique()) {
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance.m_22111_(SPEED_MODIFIER_EXTRA_SPRINTING_UUID) != null) {
                attributeinstance.m_22130_(SPEED_MODIFIER_EXTRA_SPRINTING);
            }
            if (p_21284_) {
                attributeinstance.m_22118_(SPEED_MODIFIER_EXTRA_SPRINTING);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
        if (f_19805_.equals(p_21104_) && this.hasSprintUnique()) {
            if (this.m_20142_()) {
                this.m_5496_(SoundEvents.f_12374_, 1.5f, 1.2f);
            } else {
                this.m_5496_(SoundEvents.f_12374_, 1.5f, 1.2f);
            }
        }
    }

    public boolean m_142535_(float p_149499_, float p_149500_, DamageSource p_149501_) {
        int i = this.m_5639_(p_149499_, p_149500_);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(p_149501_, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(p_149501_, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_) - 10;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.updateClientControls();
        }
        if (this.m_146895_() != null && this.hasSprintUnique()) {
            if (this.m_146895_().m_20142_() && !this.m_20142_() && this.isMoving() && this.m_20096_()) {
                this.m_6858_(true);
            } else if (this.m_20142_() && !this.isMoving()) {
                this.m_6858_(false);
            }
        } else if (this.m_20142_() && this.m_6688_() == null) {
            this.m_6858_(false);
        }
        if (this.m_20142_() && this.hasSprintUnique()) {
            this.dash();
        }
        if (this.canStepUp()) {
            if (this.m_20142_()) {
                this.m_274367_(0.5f);
            } else {
                this.m_274367_(1.0f);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMoving() {
        Entity entity;
        if (this.canDashWithWall() || this.f_19862_) {
            if (!this.canDashWithWall()) return false;
        }
        if (!((entity = this.m_146895_()) instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!(livingEntity.f_20902_ > 0.0f)) return false;
        return true;
    }

    protected boolean canDashWithWall() {
        return false;
    }

    protected boolean canStepUp() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        Minecraft mc = Minecraft.m_91087_();
    }

    protected void m_20076_() {
        super.m_20076_();
        if (this.hasSprintUnique()) {
            EntityDimensions dimensions = this.m_6972_(this.m_20089_());
            Vec3 vec3 = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)dimensions.f_20377_, this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)dimensions.f_20377_, vec3.f_82479_ * -0.25, 0.25, vec3.f_82481_ * -0.25);
        }
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        super.m_7355_(p_20135_, p_20136_);
        if ((!this.m_20142_() || this.m_20142_() && !this.hasSprintUnique()) && this.stepSounds() != null) {
            this.m_5496_(this.stepSounds(), 1.0f, 1.0f);
        }
    }

    @Nullable
    public SoundEvent stepSounds() {
        return SoundEvents.f_12010_;
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.75;
    }

    public abstract void attack();

    public abstract void secondAttack();

    public List<Entity> pickEntitys(double range, Vec3 offset) {
        return this.pickEntitys(range, offset, this.m_20205_());
    }

    public List<Entity> pickEntitys(double range, Vec3 offset, float width) {
        Vec3 vec3 = offset;
        Vec3 vec31 = this.m_20154_();
        ArrayList entities = Lists.newArrayList();
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * range, vec31.f_82480_ * range, vec31.f_82481_ * range);
        AABB aabb = this.m_20191_().m_82386_(vec31.m_7096_() * (range * 0.5), vec31.m_7098_() * (range * 0.5), vec31.m_7094_() * (range * 0.5)).m_82400_(range);
        for (Entity entity : this.m_9236_().m_45976_(Entity.class, aabb)) {
            if (!entity.m_6097_() || entity == this || entity == this.m_146895_()) continue;
            float borderSize = entity.m_6143_() + width;
            AABB collisionBB = entity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(vec3, vec32);
            if (collisionBB.m_82390_(vec3)) {
                entities.add(entity);
                continue;
            }
            if (!interceptPos.isPresent()) continue;
            entities.add(entity);
        }
        return entities;
    }

    private void dash() {
        for (Entity entity : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82377_(0.75, 0.0, 0.75))) {
            if (entity == this || this.m_146895_() != null && (this.m_146895_() == null || entity == this.m_146895_()) || this.m_7307_(entity) || !entity.m_6097_() || !((double)this.m_20270_(entity) < 26.0) || !entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)(this.m_146895_() instanceof LivingEntity ? (LivingEntity)this.m_146895_() : this)), 7.0f)) continue;
            entity.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
            if (!(entity instanceof LivingEntity)) continue;
            double d1 = entity.m_20185_() - this.m_20185_();
            double d0 = entity.m_20189_() - this.m_20189_();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            ((LivingEntity)entity).m_147240_(1.0, d1, d0);
            if (!(this.m_146895_() instanceof Player)) continue;
            ((LivingEntity)entity).m_6598_((Player)this.m_146895_());
        }
    }

    protected void m_274498_(Player p_278233_, Vec3 p_275693_) {
        super.m_274498_(p_278233_, p_275693_);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)p_278233_);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_() && this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, p_275693_);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity p_275502_) {
        return new Vec2(p_275502_.m_146909_() * 0.5f, p_275502_.m_146908_());
    }

    protected Vec3 m_274312_(Player p_278278_, Vec3 p_275506_) {
        if (this.m_20096_() && this.playerJumpPendingScale == 0.0f && !this.allowStandSliding) {
            return Vec3.f_82478_;
        }
        float f = p_278278_.f_20900_ * 0.5f;
        float f1 = p_278278_.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected float m_245547_(Player p_278336_) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public void m_7888_(int p_30591_) {
        if (p_30591_ < 0) {
            p_30591_ = 0;
        } else {
            this.allowStandSliding = true;
        }
        this.playerJumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
    }

    public void m_7199_(int p_30574_) {
        this.allowStandSliding = true;
        this.stand();
        this.m_5496_(SoundEvents.f_12374_, 1.5f, 1.2f);
    }

    protected void executeRidersJump(float p_248808_, Vec3 p_275435_) {
        double d0 = (double)1.1f * (double)p_248808_ * (double)this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
        this.setIsJumping(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (p_275435_.f_82481_ > 0.0) {
            float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f * p_248808_), 0.0, (double)(0.4f * f1 * p_248808_)));
        }
    }

    protected float m_274460_() {
        return this.m_6688_() != null ? this.m_6113_() * 0.1f : 0.02f;
    }

    public boolean canJumpOnLava() {
        return false;
    }

    public boolean hasSprintUnique() {
        return true;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public InteractionResult m_6071_(Player p_30713_, InteractionHand p_30714_) {
        ItemStack itemstack = p_30713_.m_21120_(p_30714_);
        if (itemstack.m_150930_((Item)ModItems.WRENCH.get())) {
            return super.m_6071_(p_30713_, p_30714_);
        }
        if (this.m_21223_() < this.m_21233_() && this.healItem(itemstack)) {
            this.m_5634_(20.0f);
            this.m_216990_(SoundEvents.f_12009_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        this.doPlayerRide(p_30713_);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public boolean healItem(ItemStack itemstack) {
        return itemstack.m_150930_(Items.f_42416_);
    }

    protected void doPlayerRide(Player p_30634_) {
        if (!this.m_9236_().f_46443_ && !this.m_217005_()) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_((Entity)this);
        }
    }

    private void stand() {
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_8012_() {
    }

    public boolean m_275843_() {
        return false;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() == MobEffects.f_19615_ || p_34192_.m_19544_() == MobEffects.f_19614_ ? false : super.m_7301_(p_34192_);
    }

    public float hurtRider(DamageSource damageSource, float damage) {
        if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            return damage * 0.95f;
        }
        return damage;
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    protected abstract ItemStack getPickItem();

    public ItemStack getPickStack() {
        ItemStack stack = this.getPickItem();
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        if (this.m_8077_()) {
            tag.m_128359_("CustomName", this.m_7770_().getString());
        }
        stack.m_41784_().m_128365_("ArmorData", (Tag)tag);
        return stack;
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getPickStack();
    }

    public boolean m_264410_() {
        return true;
    }

    protected boolean m_7310_(Entity p_248594_) {
        return this.m_20197_().size() <= 1;
    }
}

