/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.balloonbox.entities.entity;

import com.coldspell.balloonbox.util.ConfigHandler;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class BalloonEntity
extends Animal {
    private final int floatHeight;
    private final int maxFloatSpeed;
    private final boolean rareSpawn;
    private final float rareBalloonChance;
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_X_MOVEMENT = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_Z_MOVEMENT = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String BALLOON_TYPE = "BalloonType";
    public static final int TYPE_RED = 0;
    public static final int TYPE_BLUE = 1;
    public static final int TYPE_GREEN = 2;
    public static final int TYPE_YELLOW = 3;
    public static final int TYPE_PINK = 4;
    public static final int TYPE_RARE = 5;
    private static final int NUMBER_OF_BALLOON_TYPES = 5;
    private static final int NUMBER_OF_BALLOON_TYPES_PLUS_RARE = 6;
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_28140_ -> {
        p_28140_.put(0, new ResourceLocation("balloonbox", "textures/entity/balloon/red_balloon.png"));
        p_28140_.put(1, new ResourceLocation("balloonbox", "textures/entity/balloon/blue_balloon.png"));
        p_28140_.put(2, new ResourceLocation("balloonbox", "textures/entity/balloon/green_balloon.png"));
        p_28140_.put(3, new ResourceLocation("balloonbox", "textures/entity/balloon/yellow_balloon.png"));
        p_28140_.put(4, new ResourceLocation("balloonbox", "textures/entity/balloon/pink_balloon.png"));
        p_28140_.put(5, new ResourceLocation("balloonbox", "textures/entity/balloon/rare_balloon.png"));
    });

    public BalloonEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.floatHeight = (Integer)ConfigHandler.SETTINGS.floatHeight.get();
        this.maxFloatSpeed = (Integer)ConfigHandler.SETTINGS.maxFloatSpeed.get();
        this.rareSpawn = (Boolean)ConfigHandler.SETTINGS.rareBalloon.get();
        this.rareBalloonChance = (float)((Integer)ConfigHandler.SETTINGS.rareChance.get()).intValue() * 0.01f;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, MobSpawnType p_28136_, @javax.annotation.Nullable SpawnGroupData p_28137_, @javax.annotation.Nullable CompoundTag p_28138_) {
        p_28137_ = super.m_6518_(p_28134_, p_28135_, p_28136_, p_28137_, p_28138_);
        this.setupBalloon();
        this.m_6021_(this.m_142538_().m_123341_(), this.m_142538_().m_123342_() + this.floatHeight, this.m_142538_().m_123343_());
        return p_28137_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    private void setupBalloon() {
        if (this.rareSpawn) {
            if (this.f_19796_.nextFloat() <= this.rareBalloonChance) {
                this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)5);
            } else {
                this.setBalloonType(this.f_19796_.nextInt(5));
            }
        } else {
            this.setBalloonType(this.f_19796_.nextInt(5));
        }
        if (this.maxFloatSpeed > 0) {
            int x = this.f_19796_.nextInt(this.maxFloatSpeed + this.maxFloatSpeed) - this.maxFloatSpeed;
            int z = this.f_19796_.nextInt(this.maxFloatSpeed + this.maxFloatSpeed) - this.maxFloatSpeed;
            this.f_19804_.m_135381_(DATA_X_MOVEMENT, (Object)x);
            this.f_19804_.m_135381_(DATA_Z_MOVEMENT, (Object)z);
        } else {
            this.f_19804_.m_135381_(DATA_X_MOVEMENT, (Object)0);
            this.f_19804_.m_135381_(DATA_Z_MOVEMENT, (Object)0);
        }
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getBalloonType(), TEXTURE_BY_TYPE.get(0));
    }

    public int getBalloonType() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)1);
        this.f_19804_.m_135372_(DATA_X_MOVEMENT, (Object)1);
        this.f_19804_.m_135372_(DATA_Z_MOVEMENT, (Object)1);
    }

    public void m_7380_(CompoundTag p_28156_) {
        super.m_7380_(p_28156_);
        p_28156_.m_128405_(BALLOON_TYPE, this.getBalloonType());
    }

    public void m_7378_(CompoundTag p_28142_) {
        super.m_7378_(p_28142_);
        this.setBalloonType(p_28142_.m_128451_(BALLOON_TYPE));
    }

    public void setBalloonType(int p_28180_) {
        if (p_28180_ < 0 || p_28180_ >= 5) {
            p_28180_ = this.f_19796_.nextInt(6);
        }
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)p_28180_);
    }

    public int getXMovementSpeed() {
        return (Integer)this.f_19804_.m_135370_(DATA_X_MOVEMENT);
    }

    public int getZMovementSpeed() {
        return (Integer)this.f_19804_.m_135370_(DATA_Z_MOVEMENT);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22265_();
    }

    protected void m_8099_() {
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    public void m_8119_() {
        BlockPos pos = this.m_142538_();
        Level level = this.f_19853_;
        if (this.maxFloatSpeed > 0) {
            if (level.m_8055_(pos.m_6625_(this.floatHeight)) != Blocks.f_50016_.m_49966_()) {
                this.m_20334_((float)this.getXMovementSpeed() * 0.01f + 0.01f, 0.015f, (float)this.getZMovementSpeed() * 0.01f + 0.01f);
            } else {
                this.m_20334_((float)this.getXMovementSpeed() * 0.01f + 0.01f, -0.015f, (float)this.getZMovementSpeed() * 0.01f + 0.01f);
            }
        } else if (level.m_8055_(pos.m_6625_(this.floatHeight)) != Blocks.f_50016_.m_49966_()) {
            this.m_20334_(0.0, 0.015f, 0.0);
        } else {
            this.m_20334_(0.0, -0.015f, 0.0);
        }
        super.m_8119_();
    }
}

