/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.recipe.util.entityconditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2048;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.EntityPredicateCondition;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.TagCondition;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.TypeCondition;

public interface EntityCondition
extends Predicate<class_1297> {
    default public EntityCondition or(EntityCondition other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static EntityCondition fromString(String value) {
        class_1299 type;
        if (value.startsWith("#")) {
            return new TagCondition(class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960(value.substring(1))));
        }
        class_2960 id = new class_2960(value);
        class_1299 class_12992 = type = class_2378.field_11145.method_10250(id) ? (class_1299)class_2378.field_11145.method_10223(id) : null;
        if (type != null) {
            return new TypeCondition(type);
        }
        throw new JsonParseException("Invalid entity ID " + value);
    }

    public static EntityCondition fromJSON(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return EntityCondition.fromString(primitive.getAsString());
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            EntityCondition chainedConditions = null;
            for (JsonElement element : array) {
                EntityCondition parsedCondition = EntityCondition.fromJSON(element);
                chainedConditions = chainedConditions == null ? parsedCondition : chainedConditions.or(parsedCondition);
            }
            if (chainedConditions == null) {
                throw new JsonParseException("Failed to parse condition array. No valid entries contained!");
            }
            return chainedConditions;
        }
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            return new EntityPredicateCondition(class_2048.method_8913((JsonElement)obj));
        }
        throw new JsonParseException("Can't parse a valid entity condition!");
    }
}

