/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone;

import java.util.Map;
import java.util.function.ToIntFunction;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.skeletoncrew.bonezone.Constants;
import net.skeletoncrew.bonezone.block.BasicBoneBlock;
import net.skeletoncrew.bonezone.block.BoneCarverBlock;
import net.skeletoncrew.bonezone.block.BoneLadderBlock;
import net.skeletoncrew.bonezone.block.CandleSkullBlock;
import net.skeletoncrew.bonezone.block.CarcassBlock;
import net.skeletoncrew.bonezone.block.CustomPotBlock;
import net.skeletoncrew.bonezone.block.SpineSkullBlock;
import net.skeletoncrew.bonezone.recipe.bonecarving.BonecarvingRecipeSerializer;
import net.skeletoncrew.bonezone.recipe.mobsanding.MobsandingRecipeSerializer;
import net.skeletoncrew.bonezone.ui.bonecarving.BonecarverMenu;

public class Content
extends RegistryDataProvider {
    public Content() {
        super("bonezone");
        this.withItemTab(() -> class_1802.field_8398.method_7854());
        this.withAutoItemBlocks();
        this.recipeTypes.add("bonecarving");
        this.recipeTypes.add("mobsanding");
        this.recipeSerializers.add(BonecarvingRecipeSerializer::new, "bonecarving");
        this.recipeSerializers.add(MobsandingRecipeSerializer::new, "mobsanding");
        this.blocks.add(BoneCarverBlock::new, "bonecarver");
        this.blocks.add(BasicBoneBlock::bone, "bone_bricks");
        this.blocks.add(BasicBoneBlock::bone, "bone_mosaic");
        this.blocks.add(BoneLadderBlock::new, "bone_ladder");
        this.createPotsFor("skeleton", Constants.SKELETON_POT_TYPES, false);
        this.createPotsFor("skeleton", Constants.FLIPPED_SKELETON_POT_TYPES, true);
        this.createCandleSkull("skeleton", Constants.CANDLE_SKELETON_TYPES);
        this.blocks.add(BasicBoneBlock::wither, "wither_bone_bricks");
        this.blocks.add(BasicBoneBlock::wither, "wither_bone_mosaic");
        this.blocks.add(BoneLadderBlock::new, "wither_bone_ladder");
        this.createPotsFor("wither", Constants.WITHER_POT_TYPES, false);
        this.createPotsFor("wither", Constants.FLIPPED_WITHER_POT_TYPES, true);
        this.createCandleSkull("wither", Constants.CANDLE_WITHER_TYPES);
        this.blocks.add(BasicBoneBlock::stray, "stray_bone_bricks");
        this.blocks.add(BasicBoneBlock::stray, "stray_bone_mosaic");
        this.blocks.add(BoneLadderBlock::new, "stray_bone_ladder");
        this.createPotsFor("stray", Constants.STRAY_POT_TYPES, false);
        this.createPotsFor("stray", Constants.FLIPPED_STRAY_POT_TYPES, true);
        this.createCandleSkull("stray", Constants.CANDLE_STRAY_TYPES);
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_goat");
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_deer");
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_bird");
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_bull");
        this.blocks.add(CarcassBlock::new, "carcass");
        this.createPotsFor("creeper", Constants.CREEPER_POT_TYPES, false);
        this.createPotsFor("creeper", Constants.FLIPPED_CREEPER_POT_TYPES, true);
        this.menus.add(() -> Services.CONSTRUCTS.menuType(BonecarverMenu::fromNetwork), "bonecarver");
    }

    private void createCandleSkull(String type, Map<class_1792, CandleSkullBlock> map) {
        class_4970.class_2251 props = class_4970.class_2251.method_9637((class_3614)class_3614.field_15924).method_9626(class_2498.field_22149).method_9632(0.1f).method_22488().method_9631(Content.litBlockEmission(6));
        String nameBase = "candle_skull_" + type + "_";
        for (class_1767 color : class_1767.values()) {
            this.blocks.add(() -> new CandleSkullBlock(props, Constants.CANDLES.get(color), map), nameBase + color.method_7792());
        }
        this.blocks.add(() -> new CandleSkullBlock(props, class_1802.field_27024, map), nameBase + "regular");
        this.blocks.add(() -> new CandleSkullBlock(props, class_1802.field_8162, map), nameBase + "empty");
    }

    private static ToIntFunction<class_2680> litBlockEmission(int level) {
        return state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? level : 0;
    }

    private void createPotsFor(String type, Map<class_1792, CustomPotBlock> variants, boolean flipped) {
        String flip = flipped ? "_flipped" : "";
        class_4970.class_2251 potProps = class_4970.class_2251.method_9637((class_3614)class_3614.field_15924).method_9626(class_2498.field_22149).method_9618().method_22488();
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_8162, variants), "empty_" + type + "_pot" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17535, variants), type + "_potted_oak_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17536, variants), type + "_potted_spruce_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17537, variants), type + "_potted_birch_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17538, variants), type + "_potted_jungle_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17539, variants), type + "_potted_acacia_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17540, variants), type + "_potted_dark_oak_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_37508, variants), type + "_potted_mangrove_propagule" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_8471, variants), type + "_potted_fern" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_8491, variants), type + "_potted_dandelion" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_8880, variants), type + "_potted_poppy" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17499, variants), type + "_potted_blue_orchid" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17500, variants), type + "_potted_allium" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17501, variants), type + "_potted_azure_bluet" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17502, variants), type + "_potted_red_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17509, variants), type + "_potted_orange_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17510, variants), type + "_potted_white_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17511, variants), type + "_potted_pink_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17512, variants), type + "_potted_oxeye_daisy" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17513, variants), type + "_potted_cornflower" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17514, variants), type + "_potted_lily_of_the_valley" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17515, variants), type + "_potted_wither_rose" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17517, variants), type + "_potted_red_mushroom" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17516, variants), type + "_potted_brown_mushroom" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_8689, variants), type + "_potted_dead_bush" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_17520, variants), type + "_potted_cactus" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_8648, variants), type + "_potted_bamboo" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_21987, variants), type + "_potted_crimson_fungus" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_21988, variants), type + "_potted_warped_fungus" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_21989, variants), type + "_potted_crimson_roots" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_21990, variants), type + "_potted_warped_roots" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_28650, variants), type + "_potted_azalea" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, class_1802.field_28651, variants), type + "_potted_flowering_azalea" + flip);
    }
}

