/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.ui.bonecarving;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.skeletoncrew.bonezone.block.BoneCarverBlock;
import net.skeletoncrew.bonezone.recipe.bonecarving.AbstractBonecarvingRecipe;
import net.skeletoncrew.bonezone.ui.bonecarving.BonecarverContainer;
import net.skeletoncrew.bonezone.ui.bonecarving.ResultSlot;

public class BonecarverMenu
extends class_1703 {
    private static final CachedSupplier<class_3917<?>> MENU_TYPE = CachedSupplier.cache(() -> (class_3917)class_7923.field_41187.method_10223(new class_2960("bonezone", "bonecarver")));
    private final class_2338 bonecarverPos;
    private final class_1661 playerInv;
    protected final BonecarverContainer container;
    private final class_1731 resultContainer;
    private final class_3915 selectedRecipeIndex;
    private final class_1735 inputSlot;
    private final class_1735 outputSlot;
    long lastSoundTime;
    private class_1799 input;
    private List<AbstractBonecarvingRecipe> validRecipes;

    public BonecarverMenu(int windowId, class_1661 playerInv, class_2338 bonecarverPos) {
        super((class_3917)MENU_TYPE.get(), windowId);
        this.bonecarverPos = bonecarverPos;
        this.playerInv = playerInv;
        this.container = new BonecarverContainer(this);
        this.resultContainer = new class_1731();
        this.selectedRecipeIndex = class_3915.method_17403();
        this.validRecipes = Lists.newArrayList();
        this.input = class_1799.field_8037;
        this.inputSlot = this.method_7621(new class_1735((class_1263)this.container, 0, 20, 33));
        this.outputSlot = this.method_7621(new ResultSlot(this, (class_1263)this.resultContainer, 1, 143, 33));
        for (int invY = 0; invY < 3; ++invY) {
            for (int invX = 0; invX < 9; ++invX) {
                this.method_7621(new class_1735((class_1263)playerInv, invX + invY * 9 + 9, 8 + invX * 18, 84 + invY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.method_7621(new class_1735((class_1263)playerInv, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
        this.method_17362(this.selectedRecipeIndex);
    }

    public boolean method_7597(class_1657 player) {
        class_1937 level = player.field_6002;
        class_2338 pos = this.bonecarverPos;
        return level.method_8320(pos).method_26204() instanceof BoneCarverBlock && player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0;
    }

    public boolean method_7604(class_1657 player, int button) {
        if (this.isValidRecipeIndex(button)) {
            this.selectedRecipeIndex.method_17404(button);
            this.updateResults();
        }
        return true;
    }

    public void method_7609(class_1263 container) {
        class_1799 inputStack = this.inputSlot.method_7677();
        if (!inputStack.method_31574(this.input.method_7909())) {
            this.input = inputStack.method_7972();
            this.updateRecipes(inputStack);
        }
    }

    public class_3917<?> method_17358() {
        return (class_3917)MENU_TYPE.get();
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.resultContainer && super.method_7613(stack, slot);
    }

    public class_1799 method_7601(class_1657 player, int slotId) {
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotId);
        class_1799 unmovedItems = class_1799.field_8037;
        if (clickedSlot != null && clickedSlot.method_7681()) {
            class_1799 slotItem = clickedSlot.method_7677();
            unmovedItems = slotItem.method_7972();
            if (slotId == 1) {
                slotItem.method_7909().method_7843(slotItem, player.field_6002, player);
                if (!this.method_7616(slotItem, 2, 38, true)) {
                    return class_1799.field_8037;
                }
                clickedSlot.method_7670(slotItem, unmovedItems);
            } else if (slotId == 0 ? !this.method_7616(slotItem, 2, 38, false) : (AbstractBonecarvingRecipe.hasRecipe(player, player.field_6002, null, slotItem) ? !this.method_7616(slotItem, 0, 1, false) : (slotId >= 2 && slotId < 29 ? !this.method_7616(slotItem, 29, 38, false) : slotId >= 29 && slotId < 38 && !this.method_7616(slotItem, 2, 29, false)))) {
                return class_1799.field_8037;
            }
            if (slotItem.method_7960()) {
                clickedSlot.method_7673(class_1799.field_8037);
            }
            clickedSlot.method_7668();
            if (slotItem.method_7947() == unmovedItems.method_7947()) {
                return class_1799.field_8037;
            }
            clickedSlot.method_7667(player, slotItem);
            this.method_7623();
        }
        return unmovedItems;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.resultContainer.method_5441(1);
        this.method_7607(player, (class_1263)this.container);
    }

    public static BonecarverMenu fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        class_2338 bonecarverPos = (class_2338)Serializers.BLOCK_POS.fromByteBuf(buf);
        return new BonecarverMenu(windowId, inv, bonecarverPos);
    }

    protected int getRecipeCount() {
        return this.validRecipes.size();
    }

    protected void onItemCrafted(class_1657 player, class_1799 craftingOutput, AbstractBonecarvingRecipe recipe) {
        long worldTime;
        craftingOutput.method_7982(player.field_6002, player, craftingOutput.method_7947());
        this.resultContainer.method_7664(player);
        recipe.onCrafted(player, player.field_6002, this.bonecarverPos, craftingOutput);
        if (!this.inputSlot.method_7671(1).method_7960()) {
            this.updateResults();
        }
        if (this.lastSoundTime != (worldTime = player.field_6002.method_8510())) {
            recipe.playSound(player, player.field_6002, this.bonecarverPos, craftingOutput);
            this.lastSoundTime = worldTime;
        }
    }

    private void updateRecipes(class_1799 inputStack) {
        this.validRecipes.clear();
        this.selectedRecipeIndex.method_17404(-1);
        this.outputSlot.method_7673(class_1799.field_8037);
        if (!inputStack.method_7960()) {
            this.validRecipes = AbstractBonecarvingRecipe.findRecipes(this.playerInv.field_7546, this.playerInv.field_7546.field_6002, this.bonecarverPos, inputStack);
        }
    }

    private void updateResults() {
        AbstractBonecarvingRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            this.resultContainer.method_7662((class_1860)selectedRecipe);
            this.outputSlot.method_7673(selectedRecipe.method_8116((class_1263)this.container, null));
        } else {
            this.outputSlot.method_7673(class_1799.field_8037);
        }
        this.method_7623();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.method_17407();
    }

    public List<AbstractBonecarvingRecipe> getAvailableRecipes() {
        return this.validRecipes;
    }

    @Nullable
    public AbstractBonecarvingRecipe getSelectedRecipe() {
        return !this.validRecipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.method_17407()) ? this.validRecipes.get(this.selectedRecipeIndex.method_17407()) : null;
    }

    public boolean hasInputItem() {
        return this.inputSlot.method_7681() && !this.validRecipes.isEmpty();
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.validRecipes.size();
    }
}

