/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.recipe.bonecarving;

import com.google.gson.JsonObject;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.skeletoncrew.bonezone.recipe.bonecarving.BonecarvingRecipe;

public class BonecarvingRecipeSerializer
implements RecipeSerializer<BonecarvingRecipe> {
    private static CachedSupplier<Sound> DEFAULT_CRAFTING_SOUND = CachedSupplier.cache(() -> new Sound(SoundEvents.f_12381_, SoundSource.BLOCKS, 1.0f, 1.0f));

    public BonecarvingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient input = (Ingredient)Serializers.INGREDIENT.fromJSON(json, "input");
        ItemStack output = (ItemStack)Serializers.ITEM_STACK.fromJSON(json, "output");
        Sound sound = (Sound)Serializers.SOUND.fromJSON(json, "crafting_sound", (Object)((Sound)DEFAULT_CRAFTING_SOUND.get()));
        return new BonecarvingRecipe(recipeId, input, output, sound);
    }

    public BonecarvingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        Ingredient input = (Ingredient)Serializers.INGREDIENT.fromByteBuf(buf);
        ItemStack output = (ItemStack)Serializers.ITEM_STACK.fromByteBuf(buf);
        Sound sound = (Sound)Serializers.SOUND.fromByteBuf(buf);
        return new BonecarvingRecipe(recipeId, input, output, sound);
    }

    public void toNetwork(FriendlyByteBuf buf, BonecarvingRecipe recipe) {
        Serializers.INGREDIENT.toByteBuf(buf, (Object)recipe.input);
        Serializers.ITEM_STACK.toByteBuf(buf, (Object)recipe.output);
        Serializers.SOUND.toByteBuf(buf, (Object)recipe.sound);
    }
}

