/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.recipe.mobsanding;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.skeletoncrew.bonezone.recipe.mobsanding.MobsandingRecipe;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.EntityCondition;

public class MobsandingRecipeSerializer
implements RecipeSerializer<MobsandingRecipe> {
    public MobsandingRecipe fromJson(ResourceLocation id, JsonObject json) {
        EntityCondition conditions = EntityCondition.fromJSON(json.get("condition"));
        MobsandingRecipe.DropEntry[] drops = MobsandingRecipeSerializer.fromJson(json.get("drops"));
        return new MobsandingRecipe(id, conditions, drops);
    }

    public MobsandingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        return new MobsandingRecipe(id, entity -> false, new MobsandingRecipe.DropEntry[0]);
    }

    public void toNetwork(FriendlyByteBuf buffer, MobsandingRecipe recipe) {
    }

    public static MobsandingRecipe.DropEntry[] fromJson(JsonElement json) {
        Item dropItem;
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString() && (dropItem = (Item)Serializers.ITEM.fromJSON(json)) != null) {
            return new MobsandingRecipe.DropEntry[]{new MobsandingRecipe.DropEntry(dropItem.m_7968_(), 1.0f)};
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            ArrayList<MobsandingRecipe.DropEntry> drops = new ArrayList<MobsandingRecipe.DropEntry>();
            for (JsonElement subElement : array) {
                drops.addAll(Arrays.asList(MobsandingRecipeSerializer.fromJson(subElement)));
            }
            return (MobsandingRecipe.DropEntry[])drops.toArray(MobsandingRecipe.DropEntry[]::new);
        }
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            ItemStack stack = (ItemStack)Serializers.ITEM_STACK.fromJSON(obj, "result");
            float chance = ((Float)Serializers.FLOAT.fromJSON(obj, "chance", (Object)Float.valueOf(1.0f))).floatValue();
            return new MobsandingRecipe.DropEntry[]{new MobsandingRecipe.DropEntry(stack, chance)};
        }
        throw new JsonParseException("Invalid drop entry! Expected string, array, or object.");
    }
}

