/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone;

import java.util.Map;
import java.util.function.ToIntFunction;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.skeletoncrew.bonezone.Constants;
import net.skeletoncrew.bonezone.block.BasicBoneBlock;
import net.skeletoncrew.bonezone.block.BoneCarverBlock;
import net.skeletoncrew.bonezone.block.BoneLadderBlock;
import net.skeletoncrew.bonezone.block.CandleSkullBlock;
import net.skeletoncrew.bonezone.block.CarcassBlock;
import net.skeletoncrew.bonezone.block.CustomPotBlock;
import net.skeletoncrew.bonezone.block.SpineSkullBlock;
import net.skeletoncrew.bonezone.recipe.bonecarving.BonecarvingRecipeSerializer;
import net.skeletoncrew.bonezone.recipe.mobsanding.MobsandingRecipeSerializer;
import net.skeletoncrew.bonezone.ui.bonecarving.BonecarverMenu;

public class Content
extends RegistryDataProvider {
    public Content() {
        super("bonezone");
        this.withItemTab(() -> Items.f_42678_.m_7968_());
        this.withAutoItemBlocks();
        this.recipeTypes.add("bonecarving");
        this.recipeTypes.add("mobsanding");
        this.recipeSerializers.add(BonecarvingRecipeSerializer::new, "bonecarving");
        this.recipeSerializers.add(MobsandingRecipeSerializer::new, "mobsanding");
        this.blocks.add(BoneCarverBlock::new, "bonecarver");
        this.blocks.add(BasicBoneBlock::bone, "bone_bricks");
        this.blocks.add(BasicBoneBlock::bone, "bone_mosaic");
        this.blocks.add(BoneLadderBlock::new, "bone_ladder");
        this.createPotsFor("skeleton", Constants.SKELETON_POT_TYPES, false);
        this.createPotsFor("skeleton", Constants.FLIPPED_SKELETON_POT_TYPES, true);
        this.createCandleSkull("skeleton", Constants.CANDLE_SKELETON_TYPES);
        this.blocks.add(BasicBoneBlock::wither, "wither_bone_bricks");
        this.blocks.add(BasicBoneBlock::wither, "wither_bone_mosaic");
        this.blocks.add(BoneLadderBlock::new, "wither_bone_ladder");
        this.createPotsFor("wither", Constants.WITHER_POT_TYPES, false);
        this.createPotsFor("wither", Constants.FLIPPED_WITHER_POT_TYPES, true);
        this.createCandleSkull("wither", Constants.CANDLE_WITHER_TYPES);
        this.blocks.add(BasicBoneBlock::stray, "stray_bone_bricks");
        this.blocks.add(BasicBoneBlock::stray, "stray_bone_mosaic");
        this.blocks.add(BoneLadderBlock::new, "stray_bone_ladder");
        this.createPotsFor("stray", Constants.STRAY_POT_TYPES, false);
        this.createPotsFor("stray", Constants.FLIPPED_STRAY_POT_TYPES, true);
        this.createCandleSkull("stray", Constants.CANDLE_STRAY_TYPES);
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_goat");
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_deer");
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_bird");
        this.blocks.add(SpineSkullBlock::new, "spinal_skull_bull");
        this.blocks.add(CarcassBlock::new, "carcass");
        this.createPotsFor("creeper", Constants.CREEPER_POT_TYPES, false);
        this.createPotsFor("creeper", Constants.FLIPPED_CREEPER_POT_TYPES, true);
        this.menus.add(() -> Services.CONSTRUCTS.menuType(BonecarverMenu::fromNetwork), "bonecarver");
    }

    private void createCandleSkull(String type, Map<Item, CandleSkullBlock> map) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_56724_).m_60978_(0.1f).m_60955_().m_60953_(Content.litBlockEmission(6));
        String nameBase = "candle_skull_" + type + "_";
        for (DyeColor color : DyeColor.values()) {
            this.blocks.add(() -> new CandleSkullBlock(props, Constants.CANDLES.get(color), map), nameBase + color.m_41065_());
        }
        this.blocks.add(() -> new CandleSkullBlock(props, Items.f_151065_, map), nameBase + "regular");
        this.blocks.add(() -> new CandleSkullBlock(props, Items.f_41852_, map), nameBase + "empty");
    }

    private static ToIntFunction<BlockState> litBlockEmission(int level) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? level : 0;
    }

    private void createPotsFor(String type, Map<Item, CustomPotBlock> variants, boolean flipped) {
        String flip = flipped ? "_flipped" : "";
        BlockBehaviour.Properties potProps = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_56724_).m_60966_().m_60955_();
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41852_, variants), "empty_" + type + "_pot" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_42799_, variants), type + "_potted_oak_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_42800_, variants), type + "_potted_spruce_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_42801_, variants), type + "_potted_birch_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41826_, variants), type + "_potted_jungle_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41827_, variants), type + "_potted_acacia_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41828_, variants), type + "_potted_dark_oak_sapling" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_220175_, variants), type + "_potted_mangrove_propagule" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41865_, variants), type + "_potted_fern" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41939_, variants), type + "_potted_dandelion" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41940_, variants), type + "_potted_poppy" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41941_, variants), type + "_potted_blue_orchid" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41942_, variants), type + "_potted_allium" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41943_, variants), type + "_potted_azure_bluet" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41944_, variants), type + "_potted_red_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41945_, variants), type + "_potted_orange_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41946_, variants), type + "_potted_white_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41947_, variants), type + "_potted_pink_tulip" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41948_, variants), type + "_potted_oxeye_daisy" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41949_, variants), type + "_potted_cornflower" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41950_, variants), type + "_potted_lily_of_the_valley" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41951_, variants), type + "_potted_wither_rose" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41953_, variants), type + "_potted_red_mushroom" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41952_, variants), type + "_potted_brown_mushroom" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41866_, variants), type + "_potted_dead_bush" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41982_, variants), type + "_potted_cactus" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41911_, variants), type + "_potted_bamboo" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41954_, variants), type + "_potted_crimson_fungus" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41955_, variants), type + "_potted_warped_fungus" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41956_, variants), type + "_potted_crimson_roots" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_41957_, variants), type + "_potted_warped_roots" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_151012_, variants), type + "_potted_azalea" + flip);
        this.blocks.add(() -> new CustomPotBlock(potProps, Items.f_151013_, variants), type + "_potted_flowering_azalea" + flip);
    }
}

