/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.datagen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.DyeColor;

public class CandleSkullGen {
    private final String type;
    private final String skullTexture;
    private static final List<String> CANDLES = new ArrayList<String>();

    public CandleSkullGen(String type, String skullTexture) {
        this.type = type;
        this.skullTexture = skullTexture;
    }

    public CandleSkullGen genBlockStates() {
        File blockstatesDir = new File("output/assets/bonezone/blockstates");
        blockstatesDir.mkdirs();
        for (String candle : CANDLES) {
            String name = "candle_skull_" + this.type + "_" + candle;
            String model = "bonezone:block/candle_skull/" + this.type + "/" + candle;
            String modelLit = model + "_lit";
            String content = "{\n  \"variants\": {\n    \"facing=north,lit=false\": {\n      \"model\": \"$model\"\n    },\n    \"facing=south,lit=false\": {\n      \"model\": \"$model\",\n      \"y\": 180\n    },\n    \"facing=east,lit=false\": {\n      \"model\": \"$model\",\n      \"y\": 90\n    },\n    \"facing=west,lit=false\": {\n      \"model\": \"$model\",\n      \"y\": 270\n    }$notEmpty\n  }\n}";
            content = content.replace("$notEmpty", candle.equals("empty") ? "" : ",\n\"facing=north,lit=true\": {\n  \"model\": \"$lit\"\n},\n\"facing=south,lit=true\": {\n  \"model\": \"$lit\",\n  \"y\": 180\n},\n\"facing=east,lit=true\": {\n  \"model\": \"$lit\",\n  \"y\": 90\n},\n\"facing=west,lit=true\": {\n  \"model\": \"$lit\",\n  \"y\": 270\n}\n").replace("$model", model).replace("$lit", modelLit);
            try (FileWriter writer = new FileWriter(new File(blockstatesDir, name + ".json"));){
                writer.append(content);
            }
            catch (IOException iOException) {}
        }
        return this;
    }

    public CandleSkullGen genModels() {
        File modelDir = new File("output/assets/bonezone/models/block/candle_skull/" + this.type);
        modelDir.mkdirs();
        for (String candle : CANDLES) {
            for (int i = 0; i < 2; ++i) {
                if (candle.equals("empty") && i == 1) continue;
                String fileName = candle + (i == 0 ? "" : "_lit");
                String parent = "bonezone:block/candle_skull/candle_skull_template";
                String content = "{\n  \"parent\": \"$parent\",\n  \"textures\": {\n    \"drip\": \"bonezone:block/drip/$color\",\n    \"candle\": \"minecraft:block/$mccandle$lit\",\n    \"skull\": \"$skull\"\n  }\n}\n";
                if (candle.equals("empty")) {
                    parent = "bonezone:block/candle_skull/empty_candle_skull";
                    content = "{\n  \"parent\": \"$parent\",\n  \"textures\": {\n    \"skull\": \"$skull\"\n  }\n}\n";
                }
                String mcCandle = (String)(candle.equals("regular") ? "" : candle + "_") + "candle";
                content = content.replace("$parent", parent).replace("$color", candle).replace("$mccandle", mcCandle).replace("$skull", this.skullTexture).replace("$lit", i == 0 ? "" : "_lit");
                try (FileWriter writer = new FileWriter(new File(modelDir, fileName + ".json"));){
                    writer.append(content);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public CandleSkullGen genItemFile() {
        String name = "candle_skull_" + this.type + "_empty";
        File itemDir = new File("output/assets/bonezone/models/item");
        itemDir.mkdirs();
        String content = "{\n  \"parent\": \"bonezone:block/candle_skull/$type/empty\",\n  \"textures\": {\n      \"skull\": \"$skull\"\n    }\n}\n";
        content = content.replace("$type", this.type).replace("$skull", this.skullTexture);
        try (FileWriter writer = new FileWriter(new File(itemDir, name + ".json"));){
            writer.append(content);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    static {
        CANDLES.addAll(Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_).toList());
        CANDLES.add("regular");
        CANDLES.add("empty");
    }
}

