/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.datagen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.DyeColor;

public class UglyDataGen {
    private static String[] CROSS_PLANTS = new String[]{"acacia_sapling", "allium", "azure_bluet", "birch_sapling", "blue_orchid", "brown_mushroom", "cornflower", "crimson_fungus", "crimson_roots", "dandelion", "dark_oak_sapling", "dead_bush", "jungle_sapling", "lily_of_the_valley", "oak_sapling", "orange_tulip", "oxeye_daisy", "pink_tulip", "poppy", "red_mushroom", "spruce_sapling", "warped_fungus", "warped_roots", "white_tulip", "wither_rose", "red_tulip"};
    private static List<String> ALL = new ArrayList<String>();
    private static final String EMPTY = "empty";

    public static void generateCrossBlockstate(String prefix) {
        File blockstatesDir = new File("output/assets/bonezone/blockstates");
        blockstatesDir.mkdirs();
        for (String type : ALL) {
            for (int i = 0; i < 2; ++i) {
                String flip = i == 0 ? "" : "_flipped";
                String empty = "";
                String pot = "_potted_";
                if (type.equals(EMPTY)) {
                    empty = "empty_";
                    pot = "_pot";
                    type = "";
                }
                try (FileWriter writer = new FileWriter(new File(blockstatesDir, empty + prefix + pot + type + flip + ".json"));){
                    if (type.isBlank()) {
                        type = EMPTY;
                    }
                    writer.append("{\n  \"variants\": {\n    \"facing=north\": {\n      \"model\": \"bonezone:block/skullpot/" + prefix + "/" + type + flip + "\"\n    },\n    \"facing=south\": {\n      \"model\": \"bonezone:block/skullpot/" + prefix + "/" + type + flip + "\"\n,      \"y\": 180\n    },\n    \"facing=east\": {\n      \"model\": \"bonezone:block/skullpot/" + prefix + "/" + type + flip + "\"\n,      \"y\": 90\n    },\n    \"facing=west\": {\n      \"model\": \"bonezone:block/skullpot/" + prefix + "/" + type + flip + "\"\n,      \"y\": 270\n    }\n  }\n}");
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void generateModels(String prefix, String particle, String entity, String face) {
        File modelsDir = new File("output/assets/bonezone/models/block/skullpot/" + prefix);
        modelsDir.mkdirs();
        String texEntity = "minecraft:entity/" + entity;
        for (String type : CROSS_PLANTS) {
            UglyDataGen.make(modelsDir, type, particle, texEntity, face, "mob_head_pot_cross", "    \"plant\": \"minecraft:block/" + type + "\"\n");
        }
        UglyDataGen.make(modelsDir, "azalea", particle, texEntity, face, "mob_head_pot_azalea_bush", "\"top\": \"minecraft:block/potted_azalea_bush_top\",\n", "\"side\": \"minecraft:block/potted_azalea_bush_side\"");
        UglyDataGen.make(modelsDir, "bamboo", particle, texEntity, face, "mob_head_pot_bamboo", new String[0]);
        UglyDataGen.make(modelsDir, "cactus", particle, texEntity, face, "mob_head_pot_cactus", new String[0]);
        UglyDataGen.make(modelsDir, EMPTY, particle, texEntity, face, "mob_head_pot", new String[0]);
        UglyDataGen.make(modelsDir, "fern", particle, texEntity, face, "mob_head_pot_cross_tinted", new String[0]);
        UglyDataGen.make(modelsDir, "flowering_azalea", particle, texEntity, face, "mob_head_pot_azalea_bush", "\"top\": \"minecraft:block/potted_flowering_azalea_bush_top\",\n", "\"side\": \"minecraft:block/potted_flowering_azalea_bush_side\"");
        UglyDataGen.make(modelsDir, "mangrove_propagule", particle, texEntity, face, "mob_head_pot_mangrove_propagule", new String[0]);
    }

    private static void make(File modelsDir, String type, String particle, String texEntity, String face, String model, String ... extra) {
        for (int i = 0; i < 2; ++i) {
            try (FileWriter writer = new FileWriter(new File(modelsDir, type + (i == 0 ? "" : "_flipped") + ".json"));){
                writer.append("{\n  \"parent\": \"bonezone:block/skullpot/" + (i == 0 ? "" : "flipped_") + model + "\",\n  \"textures\": {\n    \"particle\": \"" + particle + "\",\n    \"head_north\": \"" + face + "\",\n    \"head_east\": \"" + texEntity + "\",\n    \"head_south\": \"" + texEntity + "\",\n    \"head_west\": \"" + texEntity + "\",\n    \"head_top\": \"" + texEntity + "\",\n    \"head_bottom\": \"" + texEntity + "\"");
                if (extra != null && extra.length > 0) {
                    for (String s : extra) {
                        writer.append(",\n");
                        writer.append(s);
                    }
                }
                writer.append("\n");
                writer.append("  }\n}");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void makeCandleLoot(String type) {
        FileWriter writer;
        File dir = new File("output/data/bonezone/loot_tables/blocks");
        dir.mkdirs();
        String emptyPot = "candle_skull_" + type + "_empty";
        for (DyeColor color : DyeColor.values()) {
            String blockId = "candle_skull_" + type + "_" + color.m_41065_();
            File lootFile = new File(dir, blockId + ".json");
            try (FileWriter writer2 = new FileWriter(lootFile);){
                writer2.append("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"bonezone:" + emptyPot + "\"\n        }\n      ],\n      \"rolls\": 1.0\n    },\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:" + color.m_41065_() + "_candle\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            writer = new FileWriter(new File(dir, "candle_skull_" + type + "_regular.json"));
            try {
                writer.append("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"bonezone:" + emptyPot + "\"\n        }\n      ],\n      \"rolls\": 1.0\n    },\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:candle\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            writer = new FileWriter(new File(dir, "candle_skull_" + type + "_empty.json"));
            try {
                writer.append("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"bonezone:" + emptyPot + "\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ALL.addAll(Arrays.stream(CROSS_PLANTS).toList());
        ALL.add("bamboo");
        ALL.add("mangrove_propagule");
        ALL.add("cactus");
        ALL.add("azalea");
        ALL.add(EMPTY);
        ALL.add("flowering_azalea");
        ALL.add("fern");
    }
}

