/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.recipe.util.entityconditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.EntityPredicateCondition;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.TagCondition;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.TypeCondition;

public interface EntityCondition
extends Predicate<Entity> {
    default public EntityCondition or(EntityCondition other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static EntityCondition fromString(String value) {
        EntityType type;
        if (value.startsWith("#")) {
            return new TagCondition(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(value.substring(1))));
        }
        ResourceLocation id = new ResourceLocation(value);
        EntityType entityType = type = BuiltInRegistries.f_256780_.m_7804_(id) ? (EntityType)BuiltInRegistries.f_256780_.m_7745_(id) : null;
        if (type != null) {
            return new TypeCondition(type);
        }
        throw new JsonParseException("Invalid entity ID " + value);
    }

    public static EntityCondition fromJSON(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return EntityCondition.fromString(primitive.getAsString());
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            EntityCondition chainedConditions = null;
            for (JsonElement element : array) {
                EntityCondition parsedCondition = EntityCondition.fromJSON(element);
                chainedConditions = chainedConditions == null ? parsedCondition : chainedConditions.or(parsedCondition);
            }
            if (chainedConditions == null) {
                throw new JsonParseException("Failed to parse condition array. No valid entries contained!");
            }
            return chainedConditions;
        }
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            return new EntityPredicateCondition(EntityPredicate.m_36614_((JsonElement)obj));
        }
        throw new JsonParseException("Can't parse a valid entity condition!");
    }
}

