/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.ui.bonecarving;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.skeletoncrew.bonezone.recipe.bonecarving.AbstractBonecarvingRecipe;
import net.skeletoncrew.bonezone.ui.bonecarving.BonecarverMenu;

public class BonecarverScreen
extends AbstractContainerScreen<BonecarverMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("bonezone", "textures/gui/container/bonecarver.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public BonecarverScreen(BonecarverMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        menu.container.setChangeListener(this::containerChanged);
        --this.f_97729_;
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int x, int y) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG_LOCATION);
        BonecarverScreen.m_93228_((PoseStack)poseStack, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        int scrollDepth = (int)(41.0f * this.scrollOffs);
        BonecarverScreen.m_93228_((PoseStack)poseStack, (int)(this.f_97735_ + 119), (int)(this.f_97736_ + 15 + scrollDepth), (int)(176 + (this.isScrollBarActive() ? 0 : 12)), (int)0, (int)12, (int)15);
        int recipesX = this.f_97735_ + 52;
        int recipesY = this.f_97736_ + 14;
        int lastVisible = this.startIndex + 12;
        this.renderButtons(poseStack, x, y, recipesX, recipesY, lastVisible);
        this.renderRecipes(poseStack, recipesX, recipesY, lastVisible);
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        if (this.displayRecipes) {
            int recipesX = this.f_97735_ + 52;
            int recipesY = this.f_97736_ + 14;
            int lastRecipeIndex = this.startIndex + 12;
            List<AbstractBonecarvingRecipe> availableRecipes = ((BonecarverMenu)this.f_97732_).getAvailableRecipes();
            for (int recipeIndex = this.startIndex; recipeIndex < lastRecipeIndex && recipeIndex < ((BonecarverMenu)this.f_97732_).getRecipeCount(); ++recipeIndex) {
                int buttonId = recipeIndex - this.startIndex;
                int buttonX = recipesX + buttonId % 4 * 16;
                int buttonY = recipesY + buttonId / 4 * 18 + 2;
                if (mouseX < buttonX || mouseX >= buttonX + 16 || mouseY < buttonY || mouseY >= buttonY + 18) continue;
                this.m_6057_(poseStack, availableRecipes.get(recipeIndex).m_8043_(null), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(PoseStack poseStack, int mouseX, int mouseY, int recipesX, int recipesY, int lastRecipe) {
        for (int recipeIndex = this.startIndex; recipeIndex < lastRecipe && recipeIndex < ((BonecarverMenu)this.f_97732_).getRecipeCount(); ++recipeIndex) {
            int buttonId = recipeIndex - this.startIndex;
            int buttonX = recipesX + buttonId % 4 * 16;
            int buttonY = recipesY + buttonId / 4 * 18 + 2;
            int textureUVOffset = this.f_97727_;
            if (recipeIndex == ((BonecarverMenu)this.f_97732_).getSelectedRecipeIndex()) {
                textureUVOffset += 18;
            } else if (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18) {
                textureUVOffset += 36;
            }
            BonecarverScreen.m_93228_((PoseStack)poseStack, (int)buttonX, (int)(buttonY - 1), (int)0, (int)textureUVOffset, (int)16, (int)18);
        }
    }

    private void renderRecipes(PoseStack pose, int recipesX, int recipesY, int lastVisibleRecipe) {
        List<AbstractBonecarvingRecipe> recipes = ((BonecarverMenu)this.f_97732_).getAvailableRecipes();
        for (int recipeIndex = this.startIndex; recipeIndex < lastVisibleRecipe && recipeIndex < ((BonecarverMenu)this.f_97732_).getRecipeCount(); ++recipeIndex) {
            int buttonId = recipeIndex - this.startIndex;
            int buttonX = recipesX + buttonId % 4 * 16;
            int buttonY = recipesY + buttonId / 4 * 18 + 2;
            this.f_96541_.m_91291_().m_274369_(pose, recipes.get(recipeIndex).m_8043_(null), buttonX, buttonY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int recipeBoxX = this.f_97735_ + 52;
            int recipeBoxY = this.f_97736_ + 14;
            int lastRecipeIndex = this.startIndex + 12;
            for (int recipeIndex = this.startIndex; recipeIndex < lastRecipeIndex; ++recipeIndex) {
                int buttonId = recipeIndex - this.startIndex;
                double buttonX = mouseX - (double)(recipeBoxX + buttonId % 4 * 16);
                double buttonY = mouseY - (double)(recipeBoxY + buttonId / 4 * 18);
                if (!(buttonX >= 0.0) || !(buttonY >= 0.0) || !(buttonX < 16.0) || !(buttonY < 18.0) || !((BonecarverMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, recipeIndex)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11711_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((BonecarverMenu)this.f_97732_).f_38840_, recipeIndex);
                return true;
            }
            int scrollbarX = this.f_97735_ + 119;
            int scrollbarY = this.f_97736_ + 9;
            if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 12) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int scrollbarStart = this.f_97736_ + 14;
            int scrollbarStop = scrollbarStart + 54;
            this.scrollOffs = ((float)mouseY - (float)scrollbarStart - 7.5f) / ((float)(scrollbarStop - scrollbarStart) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.isScrollBarActive()) {
            int offscreenRows = this.getOffscreenRows();
            float offsetDelta = (float)scrollAmount / (float)offscreenRows;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - offsetDelta), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)offscreenRows) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((BonecarverMenu)this.f_97732_).getRecipeCount() > 12;
    }

    protected int getOffscreenRows() {
        return (((BonecarverMenu)this.f_97732_).getRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((BonecarverMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

