/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.skeletoncrew.bonezone.recipe.mobsanding.AbstractMobsandingRecipe;
import net.skeletoncrew.bonezone.recipe.mobsanding.MobsandingRecipe;
import net.skeletoncrew.bonezone.ui.bonecarving.BonecarverMenuProvider;

public class BoneCarverBlock
extends Block {
    private static final ResourceKey<DamageType> SANDING_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("bonezone", "sanding"));
    private static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(3.5f);
    private static final Component TITLE = Component.m_237115_((String)"container.bonezone.bonecarver");
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BoneCarverBlock() {
        super(PROPERTIES);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldLevel, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitData) {
        if (worldLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BonecarverMenuProvider.openMenu(serverPlayer, pos, TITLE);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, worldLevel, pos, player, hand, hitData);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldLevel, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorAxis) {
        return state.m_60717_(mirrorAxis.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldLevel, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_141947_(Level worldLevel, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (worldLevel.m_46467_() % 20L == 1L) {
                AbstractMobsandingRecipe recipe = MobsandingRecipe.findRecipe(worldLevel, pos, entity);
                entity.m_6469_(BoneCarverBlock.getSource(worldLevel, SANDING_DAMAGE), recipe == null ? 2.0f : 3.0f);
                if (recipe != null) {
                    recipe.onCrafted(worldLevel, pos, entity);
                }
            }
        }
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> id) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        Holder.Reference damage = registry.m_246971_(id);
        return new DamageSource((Holder)damage);
    }
}

