/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.block;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleSkullBlock
extends AbstractCandleBlock
implements IBindRenderLayer,
IItemBlockProvider {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SKULL = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape CANDLE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    private static final VoxelShape BOTH = Shapes.m_83110_((VoxelShape)SKULL, (VoxelShape)CANDLE);
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    private final Map<Item, CandleSkullBlock> variants;
    private final Item contained;

    public CandleSkullBlock(BlockBehaviour.Properties props, Item candle, Map<Item, CandleSkullBlock> variants) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        variants.put(candle, this);
        this.variants = variants;
        this.contained = candle;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.m_21120_(hand);
        if (this.hasNoCandle()) {
            CandleSkullBlock toPlace = this.variants.getOrDefault(heldStack.m_41720_(), this);
            if (toPlace != this && !toPlace.hasNoCandle()) {
                level.m_7731_(pos, toPlace.applyFrom(state), 3);
                level.m_5594_(player, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
            }
        } else if (this.candleHit(hitResult)) {
            if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (heldStack.m_150930_(Items.f_42409_) || heldStack.m_150930_(Items.f_42613_))) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
            } else if (player.m_21120_(hand).m_41619_()) {
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    CandleSkullBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                } else {
                    if (!player.m_150110_().f_35937_) {
                        ItemStack giveStack = new ItemStack((ItemLike)this.contained);
                        player.m_150109_().m_36054_(giveStack);
                    }
                    level.m_5594_(player, pos, SoundEvents.f_144097_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_7731_(pos, this.getEmptyBlock().applyFrom(state), 3);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.hasNoCandle() ? SKULL : BOTH;
    }

    public boolean hasNoCandle() {
        return Items.f_41852_.equals(this.contained);
    }

    private boolean candleHit(BlockHitResult hitResult) {
        return hitResult.m_82450_().f_82480_ - (double)hitResult.m_82425_().m_123342_() > 0.5;
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return PARTICLE_OFFSETS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction lookingDirection : context.m_6232_()) {
            if (!lookingDirection.m_122434_().m_122479_()) continue;
            BlockState placedState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)lookingDirection.m_122424_());
            return (BlockState)placedState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> define) {
        define.m_61104_(new Property[]{FACING, LIT});
    }

    public RenderType getRenderLayerToBind() {
        return RenderType.m_110463_();
    }

    public boolean hasItemBlock(Block block) {
        CandleSkullBlock skull;
        return block instanceof CandleSkullBlock && (skull = (CandleSkullBlock)block).hasNoCandle();
    }

    private BlockState applyFrom(BlockState oldState) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)oldState.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public CandleSkullBlock getEmptyBlock() {
        return this.variants.get(Items.f_41852_);
    }
}

