/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.block;

import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CustomPotBlock
extends Block
implements IBindRenderLayer,
IItemBlockProvider,
SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private final Map<Item, CustomPotBlock> variants;
    private final Item contained;

    public CustomPotBlock(BlockBehaviour.Properties properties, Item contained, Map<Item, CustomPotBlock> variants) {
        super(properties);
        this.contained = contained;
        this.variants = variants;
        this.variants.put(contained, this);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public RenderType getRenderLayerToBind() {
        return RenderType.m_110463_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldLevel, BlockPos pos, Player player, InteractionHand hand, BlockHitResult clickContext) {
        CustomPotBlock toPlace;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41619_() && !this.isEmpty()) {
            if (!player.m_150110_().f_35937_) {
                ItemStack giveStack = new ItemStack((ItemLike)this.contained);
                player.m_150109_().m_36054_(giveStack);
            }
            worldLevel.m_7731_(pos, this.getEmptyBlock().applyFrom(state), 3);
            worldLevel.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (this.isEmpty() && (toPlace = this.variants.getOrDefault(heldStack.m_41720_(), this)) != this && !toPlace.isEmpty()) {
            worldLevel.m_7731_(pos, toPlace.applyFrom(state), 3);
            player.m_36220_(Stats.f_12961_);
            worldLevel.m_5594_(player, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                heldStack.m_41774_(1);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState existingFluidState = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction lookingDirection : context.m_6232_()) {
            if (!lookingDirection.m_122434_().m_122479_()) continue;
            BlockState placedState = (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)lookingDirection.m_122424_());
            return (BlockState)placedState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(existingFluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return this.isEmpty() ? super.m_7397_(world, pos, state) : new ItemStack((ItemLike)this.contained);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean hasItemBlock(Block block) {
        CustomPotBlock pot;
        return block instanceof CustomPotBlock && (pot = (CustomPotBlock)block).isEmpty();
    }

    public Item getContainedItem() {
        return this.contained;
    }

    private BlockState applyFrom(BlockState oldState) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_)))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)oldState.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public CustomPotBlock getEmptyBlock() {
        return this.variants.get(Items.f_41852_);
    }

    public boolean isEmpty() {
        return this.contained == Items.f_41852_;
    }
}

