/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.recipe.mobsanding;

import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.skeletoncrew.bonezone.recipe.mobsanding.AbstractMobsandingRecipe;
import net.skeletoncrew.bonezone.recipe.util.entityconditions.EntityCondition;

public class MobsandingRecipe
extends AbstractMobsandingRecipe {
    private static final CachedSupplier<RecipeSerializer<?>> SERIALIZER = RegistryObject.deferred((Registry)BuiltInRegistries.f_256769_, (String)"bonezone", (String)"mobsanding").cast();
    private final EntityCondition condition;
    private final DropEntry[] drops;

    public MobsandingRecipe(ResourceLocation id, EntityCondition condition, DropEntry[] drops) {
        super(id);
        this.condition = condition;
        this.drops = drops;
    }

    @Override
    public boolean canCraft(Level worldLevel, BlockPos pos, Entity target) {
        return this.condition.test(target);
    }

    @Override
    public void onCrafted(Level worldLevel, BlockPos pos, Entity target) {
        if (!worldLevel.f_46443_) {
            for (DropEntry drop : this.drops) {
                if (!MathsHelper.tryPercentage((double)drop.chance)) continue;
                target.m_19983_(drop.item.m_41777_());
            }
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public static class DropEntry {
        public ItemStack item;
        public float chance;

        public DropEntry(ItemStack item, float chance) {
            this.item = item;
            this.chance = chance;
        }
    }
}

