/*
 * Decompiled with CFR 0.152.
 */
package net.skeletoncrew.bonezone.ui.bonecarving;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.skeletoncrew.bonezone.block.BoneCarverBlock;
import net.skeletoncrew.bonezone.recipe.bonecarving.AbstractBonecarvingRecipe;
import net.skeletoncrew.bonezone.ui.bonecarving.BonecarverContainer;
import net.skeletoncrew.bonezone.ui.bonecarving.ResultSlot;

public class BonecarverMenu
extends AbstractContainerMenu {
    private static final CachedSupplier<MenuType<?>> MENU_TYPE = CachedSupplier.cache(() -> (MenuType)BuiltInRegistries.f_256818_.m_7745_(new ResourceLocation("bonezone", "bonecarver")));
    private final BlockPos bonecarverPos;
    private final Inventory playerInv;
    protected final BonecarverContainer container;
    private final ResultContainer resultContainer;
    private final DataSlot selectedRecipeIndex;
    private final Slot inputSlot;
    private final Slot outputSlot;
    long lastSoundTime;
    private ItemStack input;
    private List<AbstractBonecarvingRecipe> validRecipes;

    public BonecarverMenu(int windowId, Inventory playerInv, BlockPos bonecarverPos) {
        super((MenuType)MENU_TYPE.get(), windowId);
        this.bonecarverPos = bonecarverPos;
        this.playerInv = playerInv;
        this.container = new BonecarverContainer(this);
        this.resultContainer = new ResultContainer();
        this.selectedRecipeIndex = DataSlot.m_39401_();
        this.validRecipes = Lists.newArrayList();
        this.input = ItemStack.f_41583_;
        this.inputSlot = this.m_38897_(new Slot((Container)this.container, 0, 20, 33));
        this.outputSlot = this.m_38897_(new ResultSlot(this, (Container)this.resultContainer, 1, 143, 33));
        for (int invY = 0; invY < 3; ++invY) {
            for (int invX = 0; invX < 9; ++invX) {
                this.m_38897_(new Slot((Container)playerInv, invX + invY * 9 + 9, 8 + invX * 18, 84 + invY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInv, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public boolean m_6875_(Player player) {
        BlockPos pos;
        Level level = player.m_9236_();
        return level.m_8055_(pos = this.bonecarverPos).m_60734_() instanceof BoneCarverBlock && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_6366_(Player player, int button) {
        if (this.isValidRecipeIndex(button)) {
            this.selectedRecipeIndex.m_6422_(button);
            this.updateResults();
        }
        return true;
    }

    public void m_6199_(Container container) {
        ItemStack inputStack = this.inputSlot.m_7993_();
        if (!inputStack.m_150930_(this.input.m_41720_())) {
            this.input = inputStack.m_41777_();
            this.updateRecipes(inputStack);
        }
    }

    public MenuType<?> m_6772_() {
        return (MenuType)MENU_TYPE.get();
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slotId) {
        Slot clickedSlot = (Slot)this.f_38839_.get(slotId);
        ItemStack unmovedItems = ItemStack.f_41583_;
        if (clickedSlot != null && clickedSlot.m_6657_()) {
            ItemStack slotItem = clickedSlot.m_7993_();
            unmovedItems = slotItem.m_41777_();
            if (slotId == 1) {
                slotItem.m_41720_().m_7836_(slotItem, player.m_9236_(), player);
                if (!this.m_38903_(slotItem, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                clickedSlot.m_40234_(slotItem, unmovedItems);
            } else if (slotId == 0 ? !this.m_38903_(slotItem, 2, 38, false) : (AbstractBonecarvingRecipe.hasRecipe(player, player.m_9236_(), null, slotItem) ? !this.m_38903_(slotItem, 0, 1, false) : (slotId >= 2 && slotId < 29 ? !this.m_38903_(slotItem, 29, 38, false) : slotId >= 29 && slotId < 38 && !this.m_38903_(slotItem, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                clickedSlot.m_5852_(ItemStack.f_41583_);
            }
            clickedSlot.m_6654_();
            if (slotItem.m_41613_() == unmovedItems.m_41613_()) {
                return ItemStack.f_41583_;
            }
            clickedSlot.m_142406_(player, slotItem);
            this.m_38946_();
        }
        return unmovedItems;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.m_150411_(player, (Container)this.container);
    }

    public static BonecarverMenu fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        BlockPos bonecarverPos = (BlockPos)Serializers.BLOCK_POS.fromByteBuf(buf);
        return new BonecarverMenu(windowId, inv, bonecarverPos);
    }

    protected int getRecipeCount() {
        return this.validRecipes.size();
    }

    protected void onItemCrafted(Player player, ItemStack craftingOutput, AbstractBonecarvingRecipe recipe) {
        long worldTime;
        craftingOutput.m_41678_(player.m_9236_(), player, craftingOutput.m_41613_());
        this.resultContainer.m_58395_(player, List.of(craftingOutput));
        recipe.onCrafted(player, player.m_9236_(), this.bonecarverPos, craftingOutput);
        if (!this.inputSlot.m_6201_(1).m_41619_()) {
            this.updateResults();
        }
        if (this.lastSoundTime != (worldTime = player.m_9236_().m_46467_())) {
            recipe.playSound(player, player.m_9236_(), this.bonecarverPos, craftingOutput);
            this.lastSoundTime = worldTime;
        }
    }

    private void updateRecipes(ItemStack inputStack) {
        this.validRecipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        if (!inputStack.m_41619_()) {
            this.validRecipes = AbstractBonecarvingRecipe.findRecipes(this.playerInv.f_35978_, this.playerInv.f_35978_.m_9236_(), this.bonecarverPos, inputStack);
        }
    }

    private void updateResults() {
        AbstractBonecarvingRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            this.resultContainer.m_6029_((Recipe)selectedRecipe);
            this.outputSlot.m_5852_(selectedRecipe.m_5874_((Container)this.container, null));
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<AbstractBonecarvingRecipe> getAvailableRecipes() {
        return this.validRecipes;
    }

    @Nullable
    public AbstractBonecarvingRecipe getSelectedRecipe() {
        return !this.validRecipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_()) ? this.validRecipes.get(this.selectedRecipeIndex.m_6501_()) : null;
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.validRecipes.isEmpty();
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.validRecipes.size();
    }
}

