/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.connector;

import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.antarcticgardens.newage.NewAgeRenderTypes;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.newage.content.electricity.wire.ElectricWireItem;
import org.antarcticgardens.newage.content.electricity.wire.WireType;
import org.antarcticgardens.newage.tools.ConversionTool;
import org.antarcticgardens.newage.tools.RaycastUtil;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElectricalConnectorRenderer
implements class_827<ElectricalConnectorBlockEntity> {
    public static final float SAG_FACTOR = 0.92f;
    public static final int[] TOO_LONG1 = new int[]{150, 0, 0, 255};
    public static final int[] TOO_LONG2 = new int[]{204, 0, 0, 255};

    public ElectricalConnectorRenderer(class_5614.class_5615 context) {
    }

    public void render(ElectricalConnectorBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_1792 to;
        class_4588 consumer = buffer.getBuffer(NewAgeRenderTypes.WIRE);
        class_2338 pos = blockEntity.method_11016();
        Vector3f from = new Vector3f(0.0f);
        for (Map.Entry<class_2338, WireType> e : blockEntity.getConnectorPositions().entrySet()) {
            if (e.getKey().hashCode() > blockEntity.method_11016().hashCode()) continue;
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            Matrix4f pose = ConversionTool.toJoml(poseStack.method_23760().method_23761());
            to = new Vector3f((float)(e.getKey().method_10263() - pos.method_10263()), (float)(e.getKey().method_10264() - pos.method_10264()), (float)(e.getKey().method_10260() - pos.method_10260()));
            this.renderWire(consumer, pose, from, (Vector3f)to, blockEntity, e.getValue().getColor1(), e.getValue().getColor2());
            poseStack.method_22909();
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && class_310.method_1551().field_1690.method_31044().method_31034()) {
            ElectricWireItem wire;
            class_2338 bound;
            class_1799 itemInHand = player.method_6047();
            if (!(itemInHand.method_7909() instanceof ElectricWireItem)) {
                itemInHand = player.method_6079();
            }
            if ((to = itemInHand.method_7909()) instanceof ElectricWireItem && (bound = (wire = (ElectricWireItem)to).getBoundConnector(itemInHand)) != null && bound.equals((Object)blockEntity.method_11016())) {
                class_243 eyePos = class_310.method_1551().field_1773.method_19418().method_19326();
                class_243 endPos = eyePos.method_1019(player.method_5828(partialTick).method_1029().method_1021(2.0));
                class_239 hit = RaycastUtil.pickBlockFromPos(blockEntity.method_10997(), eyePos, player.method_5828(partialTick), class_310.method_1551().field_1761.method_2904());
                if (hit instanceof class_3965) {
                    class_3965 blockHit = (class_3965)hit;
                    class_243 vec = eyePos.method_1019(blockHit.method_17784().method_1020(eyePos).method_1021((double)0.9f));
                    if (eyePos.method_1022(endPos) > eyePos.method_1022(vec)) {
                        endPos = vec;
                    }
                }
                Vector3f to2 = new Vector3f((float)(endPos.field_1352 - (double)pos.method_10263() - 0.5), (float)(endPos.field_1351 - (double)pos.method_10264() - 0.5), (float)(endPos.field_1350 - (double)pos.method_10260() - 0.5));
                double distance = endPos.method_1028((double)bound.method_10263() + 0.5, (double)bound.method_10264() + 0.5, (double)bound.method_10260() + 0.5);
                if (distance > class_3532.method_33723((double)32.0)) {
                    return;
                }
                int[] color1 = wire.getWireType().getColor1();
                int[] color2 = wire.getWireType().getColor2();
                if (class_310.method_1551().field_1761 != null && hit instanceof class_3965) {
                    class_3965 blockHit = (class_3965)hit;
                    class_2586 class_25862 = blockEntity.method_10997().method_8321(blockHit.method_17777());
                    if (class_25862 instanceof ElectricalConnectorBlockEntity) {
                        ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)class_25862;
                        if (connector.isConnected(blockEntity.method_11016())) {
                            return;
                        }
                        to2 = new Vector3f((float)(blockHit.method_17777().method_10263() - pos.method_10263()), (float)(blockHit.method_17777().method_10264() - pos.method_10264()), (float)(blockHit.method_17777().method_10260() - pos.method_10260()));
                        distance = connector.method_11016().method_10262((class_2382)blockEntity.method_11016());
                    }
                }
                if (distance >= class_3532.method_33723((double)16.0)) {
                    color1 = TOO_LONG1;
                    color2 = TOO_LONG2;
                }
                poseStack.method_22903();
                poseStack.method_22904(0.5, 0.5, 0.5);
                Matrix4f pose = ConversionTool.toJoml(poseStack.method_23760().method_23761());
                this.renderWire(consumer, pose, to2, from, blockEntity, color1, color2);
                poseStack.method_22909();
            }
        }
    }

    private void renderWire(class_4588 consumer, Matrix4f pose, Vector3f from, Vector3f to, ElectricalConnectorBlockEntity blockEntity, int[] color1, int[] color2) {
        Vector3f lastSection = from;
        Vector3f direction = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        float distance = to.distance((Vector3fc)from);
        int sections = (int)Math.ceil(distance * (float)((Integer)NewAgeConfig.getClient().wireSectionsPerMeter.get()).intValue());
        float perSection = distance / (float)sections;
        for (int i = 0; i <= sections; ++i) {
            int[] color = i % 2 == 0 ? color1 : color2;
            Vector3f sectionTo = new Vector3f((Vector3fc)direction).mul(perSection * (float)i).add(0.0f, this.catenary(i, distance, sections), 0.0f);
            this.wireSection(consumer, pose, lastSection, sectionTo.add((Vector3fc)from), color, this.calculateLighting(blockEntity, lastSection, sectionTo));
            lastSection = sectionTo;
        }
    }

    public boolean shouldRenderOffScreen(ElectricalConnectorBlockEntity blockEntity) {
        return true;
    }

    private int calculateLighting(class_2586 entity, Vector3f pos, Vector3f pos1) {
        class_2338 blockPos = new class_2338((class_2382)entity.method_11016()).method_10069(Math.round(pos.x), Math.round(pos.y), Math.round(pos.z));
        class_2338 blockPos1 = new class_2338((class_2382)entity.method_11016()).method_10069(Math.round(pos1.x), Math.round(pos1.y), Math.round(pos1.z));
        int sky = entity.method_10997().method_8314(class_1944.field_9284, blockPos);
        int block = entity.method_10997().method_8314(class_1944.field_9282, blockPos);
        int sky1 = entity.method_10997().method_8314(class_1944.field_9284, blockPos1);
        int block1 = entity.method_10997().method_8314(class_1944.field_9282, blockPos1);
        return class_765.method_23687((int)Math.max(block, block1), (int)Math.max(sky, sky1));
    }

    private float catenary(double x, double length, int sections) {
        double a = length / 16.0 * (double)0.92f;
        x = x / (double)sections * 2.0 - 1.0;
        return (float)((Math.cosh(x) - Math.cosh(1.0)) * a);
    }

    private void wireSection(class_4588 consumer, Matrix4f pose, Vector3f from, Vector3f to, int[] color, int light) {
        Vector3f up;
        Vector3f direction = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        if (this.isVertical(direction, up = new Vector3f(0.0f, 1.0f, 0.0f))) {
            up = new Vector3f(1.0f, 0.0f, 0.0f);
        }
        pose = new Matrix4f((Matrix4fc)pose).translate((Vector3fc)from).rotateTowards((Vector3fc)direction, (Vector3fc)up);
        class_1159 mojangPose = ConversionTool.toMojang(pose);
        int r = color[0];
        int g = color[1];
        int b = color[2];
        int z = color[3];
        float f = ((Double)NewAgeConfig.getClient().wireThickness.get()).floatValue() / 2.0f;
        float distance = from.distance((Vector3fc)to);
        consumer.method_22918(mojangPose, -f, -f, 0.0f).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, -f, -f, distance).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, f, f, distance).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, f, f, 0.0f).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, f, -f, 0.0f).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, f, -f, distance).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, -f, f, distance).method_1336(r, g, b, z).method_22916(light).method_1344();
        consumer.method_22918(mojangPose, -f, f, 0.0f).method_1336(r, g, b, z).method_22916(light).method_1344();
    }

    private boolean isVertical(Vector3f vec, Vector3f up) {
        return vec.equals((Object)up) || vec.equals((Object)up.mul(-1.0f));
    }
}

