/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.wire;

import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3417;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.newage.content.electricity.wire.WireType;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricWireItem
extends class_1792 {
    public static final double MAX_DISTANCE = 16.0;
    private final WireType wireType;

    public ElectricWireItem(class_1792.class_1793 properties, WireType wireType) {
        super(properties);
        this.wireType = wireType;
    }

    public static ElectricWireItem newCopperWire(class_1792.class_1793 properties) {
        return new ElectricWireItem(properties, WireType.COPPER);
    }

    public static ElectricWireItem newIronWire(class_1792.class_1793 properties) {
        return new ElectricWireItem(properties, WireType.IRON);
    }

    public static ElectricWireItem newGoldenWire(class_1792.class_1793 properties) {
        return new ElectricWireItem(properties, WireType.GOLD);
    }

    public static ElectricWireItem newDiamondWire(class_1792.class_1793 properties) {
        return new ElectricWireItem(properties, WireType.DIAMOND);
    }

    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, class_1268 usedHand) {
        class_1799 item = player.method_5998(usedHand);
        class_2338 boundToPos = this.getBoundConnector(item);
        if (boundToPos != null && player.method_5715()) {
            this.playUnboundSound((class_1297)player);
            player.method_7353((class_2561)class_2561.method_43471((String)"item.create_new_age.wire.message.unbound"), true);
            item.method_7983("boundTo");
            return class_1271.method_22427((Object)item);
        }
        return class_1271.method_22430((Object)item);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (isSelected) {
            class_2338 boundToPos = this.getBoundConnector(stack);
            if (boundToPos == null) {
                return;
            }
            if (!(level.method_8321(boundToPos) instanceof ElectricalConnectorBlockEntity)) {
                stack.method_7983("boundTo");
            }
            if (entity.method_5649((double)boundToPos.method_10263(), (double)boundToPos.method_10264(), (double)boundToPos.method_10260()) > 768.0) {
                stack.method_7983("boundTo");
                this.playUnboundSound(entity);
                if (entity instanceof class_1657) {
                    class_1657 pl = (class_1657)entity;
                    pl.method_7353((class_2561)class_2561.method_43469((String)"item.create_new_age.wire.message.too_far", (Object[])new Object[]{16}), true);
                }
            }
        }
    }

    public class_1269 method_7884(class_1838 context) {
        class_2586 clickedEntity = context.method_8045().method_8321(context.method_8037());
        class_2338 boundToPos = this.getBoundConnector(context.method_8041());
        if (clickedEntity instanceof ElectricalConnectorBlockEntity) {
            ElectricalConnectorBlockEntity clickedConnector = (ElectricalConnectorBlockEntity)clickedEntity;
            if (boundToPos == null) {
                this.setBoundConnector(context.method_8041(), clickedConnector);
                this.playBoundSound((class_1297)context.method_8036());
                return class_1269.field_5812;
            }
            class_2338 clickedPos = clickedConnector.method_11016();
            if (boundToPos.equals((Object)clickedPos)) {
                context.method_8036().method_7353((class_2561)class_2561.method_43471((String)"item.create_new_age.wire.message.self_connect"), true);
                context.method_8041().method_7983("boundTo");
                return class_1269.field_5814;
            }
            if (!clickedPos.method_19771((class_2382)boundToPos, 16.0)) {
                context.method_8036().method_7353((class_2561)class_2561.method_43469((String)"item.create_new_age.wire.message.too_far", (Object[])new Object[]{16}), true);
                return class_1269.field_5814;
            }
            if (clickedConnector.isConnected(boundToPos)) {
                context.method_8036().method_7353((class_2561)class_2561.method_43471((String)"item.create_new_age.wire.message.already_connected"), true);
                context.method_8041().method_7983("boundTo");
                return class_1269.field_5814;
            }
            class_2586 boundToEntity = context.method_8045().method_8321(boundToPos);
            if (boundToEntity instanceof ElectricalConnectorBlockEntity) {
                ElectricalConnectorBlockEntity boundToConnector = (ElectricalConnectorBlockEntity)boundToEntity;
                context.method_8041().method_7983("boundTo");
                boundToConnector.connect(clickedConnector, this.wireType);
                if (!context.method_8036().method_7337()) {
                    context.method_8041().method_7934(1);
                }
                this.playBoundSound((class_1297)context.method_8036());
                context.method_8036().method_7353((class_2561)class_2561.method_43471((String)"item.create_new_age.wire.message.connected"), true);
                return class_1269.field_21466;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private void playBoundSound(class_1297 entity) {
        entity.method_5783(class_3417.field_15062, 1.0f, 1.0f);
    }

    private void playUnboundSound(class_1297 entity) {
        entity.method_5783(class_3417.field_15184, 1.0f, 1.0f);
    }

    public class_2338 getBoundConnector(class_1799 stack) {
        class_2487 tag = stack.method_7941("boundTo");
        if (tag == null) {
            return null;
        }
        return class_2512.method_10691((class_2487)tag);
    }

    public WireType getWireType() {
        return this.wireType;
    }

    private void setBoundConnector(class_1799 stack, ElectricalConnectorBlockEntity connector) {
        stack.method_7959("boundTo", (class_2520)class_2512.method_10692((class_2338)connector.method_11016()));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)Lang.translate((String)"tooltip.create_new_age.transfers", (Object[])new Object[0]).style(class_124.field_1080).component());
        tooltip.add((class_2561)Lang.text((String)" ").translate("tooltip.create_new_age.energy_per_second", new Object[]{StringFormattingTool.formatLong(this.wireType.getConductivity() * 20L)}).style(class_124.field_1075).component());
    }
}

