/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.energiser;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.antarcticgardens.newage.NewAgeBlockEntityTypes;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.energiser.EnergiserBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergiserBlock
extends HorizontalKineticBlock
implements IBE<EnergiserBlockEntity> {
    private final int tier;
    private BlockEntityEntry<EnergiserBlockEntity> entry;

    public EnergiserBlock(class_4970.class_2251 properties, int tier, BlockEntityEntry<EnergiserBlockEntity> entry) {
        super(properties.method_9629(2.5f, 1.0f));
        this.entry = entry;
        this.tier = tier;
    }

    public static int getStrength(int tier) {
        return (int)(Math.pow(2.0, tier * 2) * (Double)NewAgeConfig.getCommon().energiserSpeedMultiplier.get());
    }

    public static long getCapacity(int tier) {
        return (long)(Math.pow(10.0, tier) * 1000.0);
    }

    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        if (context instanceof class_3727 && ((class_3727)context).method_32480() instanceof class_1657) {
            return AllShapes.CASING_14PX.get(class_2350.field_11033);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 preferredSide = this.getPreferredHorizontalFacing(context);
        if (preferredSide != null) {
            return (class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)preferredSide);
        }
        return super.method_9605(context);
    }

    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10166();
    }

    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10166();
    }

    public Class<EnergiserBlockEntity> getBlockEntityClass() {
        return EnergiserBlockEntity.class;
    }

    public class_2591<? extends EnergiserBlockEntity> getBlockEntityType() {
        return (class_2591)this.entry.get();
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)Lang.translate((String)"tooltip.create_new_age.speed", (Object[])new Object[0]).style(class_124.field_1080).component());
        tooltip.add((class_2561)Lang.text((String)" ").translate("tooltip.create_new_age.energy_per_second", new Object[]{StringFormattingTool.formatLong((long)EnergiserBlock.getStrength(this.tier) * 20L)}).style(class_124.field_1075).add(Lang.text((String)" ").translate("tooltip.create_new_age.per_rpm", new Object[]{10}).style(class_124.field_1080)).component());
        tooltip.add((class_2561)Lang.translate((String)"tooltip.create_new_age.stores", (Object[])new Object[0]).style(class_124.field_1080).component());
        tooltip.add((class_2561)Lang.text((String)" ").translate("tooltip.create_new_age.energy", new Object[]{StringFormattingTool.formatLong(EnergiserBlock.getCapacity(this.tier))}).style(class_124.field_1075).component());
    }

    public static class_2248 createT1(class_4970.class_2251 properties) {
        return new EnergiserBlock(properties, 1, NewAgeBlockEntityTypes.ENERGISER_T1);
    }

    public static class_2248 createT2(class_4970.class_2251 properties) {
        return new EnergiserBlock(properties, 2, NewAgeBlockEntityTypes.ENERGISER_T2);
    }

    public static class_2248 createT3(class_4970.class_2251 properties) {
        return new EnergiserBlock(properties, 3, NewAgeBlockEntityTypes.ENERGISER_T3);
    }
}

