/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.energy;

import earth.terrarium.botarium.api.energy.EnergySnapshot;
import earth.terrarium.botarium.api.energy.SimpleEnergySnapshot;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class ItemEnergyContainer
implements StatefulEnergyContainer<class_1799> {
    private final long capacity;
    private long energy;

    public ItemEnergyContainer(class_1799 itemStack, long maxCapacity) {
        this.capacity = maxCapacity;
        this.deserialize(itemStack.method_7911("BotariumData"));
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = class_3532.method_24156((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = class_3532.method_24156((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = energy;
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxCapacity() {
        return this.capacity;
    }

    @Override
    public long maxInsert() {
        return 1024L;
    }

    @Override
    public long maxExtract() {
        return 1024L;
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        tag.method_10544("Energy", this.energy);
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag) {
        this.energy = tag.method_10537("Energy");
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    @Override
    public void update(class_1799 stack) {
        this.serialize(stack.method_7911("BotariumData"));
    }
}

