/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.fluid;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.SimpleFluidSnapshot;
import earth.terrarium.botarium.api.fluid.UpdatingFluidContainer;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntToLongFunction;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3612;

public class SimpleUpdatingFluidContainer
implements UpdatingFluidContainer<class_2586> {
    public class_2371<FluidHolder> storedFluid;
    public final IntToLongFunction maxAmount;
    public final BiPredicate<Integer, FluidHolder> fluidFilter;
    public final Updatable updatable;

    public SimpleUpdatingFluidContainer(Updatable updatable, IntToLongFunction maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this.updatable = updatable;
        this.maxAmount = maxAmount;
        this.fluidFilter = fluidFilter;
        this.storedFluid = class_2371.method_10213((int)tanks, (Object)FluidHooks.emptyFluid());
    }

    public SimpleUpdatingFluidContainer(Updatable updatable, long maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this(updatable, integer -> maxAmount, tanks, fluidFilter);
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount(class_3532.method_24156((long)fluid.getFluidAmount(), (long)0L, (long)this.maxAmount.applyAsLong(i)));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = class_3532.method_24156((long)fluid.getFluidAmount(), (long)0L, (long)(this.maxAmount.applyAsLong(i) - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = class_3532.method_24156((long)fluid.getFluidAmount(), (long)0L, (long)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    public long internalInsert(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount(class_3532.method_24156((long)fluid.getFluidAmount(), (long)0L, (long)this.maxAmount.applyAsLong(i)));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = class_3532.method_24156((long)fluid.getFluidAmount(), (long)0L, (long)(this.maxAmount.applyAsLong(i) - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = class_3532.method_24156((long)fluid.getFluidAmount(), (long)0L, (long)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().method_15780(toInsert.getFluid())) {
            long extracted = class_3532.method_24156((long)toInsert.getFluidAmount(), (long)0L, (long)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - extracted);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(class_3612.field_15906);
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        this.storedFluid.set(slot, (Object)fluid);
    }

    @Override
    public List<FluidHolder> getFluids() {
        return this.storedFluid;
    }

    @Override
    public int getSize() {
        return this.getFluids().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getFluids().isEmpty() || this.getFluids().get(0) == null || this.getFluids().get(0).isEmpty();
    }

    public void clear() {
        this.storedFluid.clear();
        this.update();
    }

    @Override
    public SimpleUpdatingFluidContainer copy() {
        return new SimpleUpdatingFluidContainer(this.updatable, this.maxAmount, this.getSize(), this.fluidFilter);
    }

    @Override
    public long getTankCapacity(int slot) {
        return this.maxAmount.applyAsLong(slot);
    }

    @Override
    public void fromContainer(FluidContainer container) {
        this.storedFluid = class_2371.method_10213((int)container.getSize(), (Object)FluidHooks.emptyFluid());
        for (int i = 0; i < container.getSize(); ++i) {
            this.storedFluid.set(i, (Object)container.getFluids().get(i).copyHolder());
        }
    }

    @Override
    public void deserialize(class_2487 tag) {
        class_2499 fluids = tag.method_10554("StoredFluids", 10);
        for (int i = 0; i < fluids.size(); ++i) {
            class_2487 fluid = fluids.method_10602(i);
            this.storedFluid.set(i, (Object)FluidHooks.fluidFromCompound(fluid));
        }
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        if (!this.storedFluid.isEmpty()) {
            class_2499 tags = new class_2499();
            for (FluidHolder fluidHolder : this.storedFluid) {
                tags.add((Object)fluidHolder.serialize());
            }
            tag.method_10566("StoredFluids", (class_2520)tags);
        }
        return tag;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    public void update() {
        this.updatable.update();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    @Override
    public void update(class_2586 block) {
        this.updatable.update();
    }
}

