/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid;

import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.UpdatingFluidContainer;
import earth.terrarium.botarium.fabric.fluid.ExtendedFluidContainer;
import earth.terrarium.botarium.fabric.fluid.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.ManualSyncing;
import earth.terrarium.botarium.fabric.fluid.WrappedFluidHolder;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2586;

public class FabricBlockFluidContainer
extends ExtendedFluidContainer
implements Storage<FluidVariant>,
ManualSyncing {
    private final UpdatingFluidContainer<class_2586> container;
    private final class_2586 block;

    public FabricBlockFluidContainer(UpdatingFluidContainer<class_2586> container, class_2586 entity) {
        this.container = container;
        this.block = entity;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        List<FluidHolder> fluids = this.container.getFluids();
        return IntStream.range(0, fluids.size()).mapToObj(index -> new WrappedFluidHolder(this, (FluidHolder)fluids.get(index), this.container::extractFromSlot, this.container.getTankCapacity(index))).map(holder -> holder).iterator();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        this.container.update(this.block);
    }
}

