/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.network;

import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.newage.content.electricity.network.ElectricalNetworkPathManager;
import org.antarcticgardens.newage.content.electricity.network.ElectricalNetworkTicker;
import org.antarcticgardens.newage.content.electricity.network.NetworkPath;
import org.antarcticgardens.newage.content.electricity.network.NetworkPathConductivityContext;

public class ElectricalNetwork {
    private final List<ElectricalConnectorBlockEntity> nodes = new ArrayList<ElectricalConnectorBlockEntity>();
    private final Map<ElectricalConnectorBlockEntity, BotariumEnergyBlock<?>> consumers = new HashMap();
    private final ElectricalNetworkPathManager pathManager = new ElectricalNetworkPathManager();

    public ElectricalNetwork(ElectricalConnectorBlockEntity base) {
        this.nodes.add(base);
    }

    public void addNode(ElectricalConnectorBlockEntity node) {
        this.addNode(node, new ArrayList<ElectricalConnectorBlockEntity>());
        this.updateConsumers();
    }

    private void addNode(ElectricalConnectorBlockEntity node, List<ElectricalConnectorBlockEntity> processedNodes) {
        if (!this.nodes.contains((Object)node)) {
            this.nodes.add(node);
        }
        processedNodes.add(node);
        if (node.getNetwork() != this) {
            if (node.getNetwork() != null) {
                node.getNetwork().destroy();
            }
            node.setNetwork(this);
            for (ElectricalConnectorBlockEntity connector : node.getConnectors().keySet()) {
                if (processedNodes.contains((Object)connector)) continue;
                this.addNode(connector, processedNodes);
            }
        }
        for (ElectricalConnectorBlockEntity connectedNode : node.getConnectors().keySet()) {
            this.pathManager.addConnection(node, connectedNode);
        }
    }

    public void updateConsumers() {
        this.consumers.clear();
        for (ElectricalConnectorBlockEntity node : this.nodes) {
            class_2586 entity;
            if (node.method_10997() == null || !((entity = node.method_10997().method_8321(node.getSupportingBlockPos())) instanceof BotariumEnergyBlock)) continue;
            BotariumEnergyBlock energyBlock = (BotariumEnergyBlock)entity;
            if (entity instanceof ElectricalConnectorBlockEntity || !energyBlock.getEnergyStorage().allowsInsertion()) continue;
            this.consumers.put(node, energyBlock);
        }
        if (!this.getWorld().method_8608()) {
            ElectricalNetworkTicker.addNetwork(this);
        }
    }

    public long insert(ElectricalConnectorBlockEntity from, long amount, boolean simulate) {
        if (this.consumers.isEmpty()) {
            return 0L;
        }
        AtomicLong inserted = new AtomicLong();
        long perConsumer = (long)Math.ceil((double)amount / (double)this.consumers.size());
        NetworkPathConductivityContext context = simulate ? new NetworkPathConductivityContext(this.pathManager.getConductivityContext()) : this.pathManager.getConductivityContext();
        this.consumers.entrySet().stream().sorted(Comparator.comparingDouble(e -> (double)((BotariumEnergyBlock)e.getValue()).getEnergyStorage().getStoredEnergy() / (double)((BotariumEnergyBlock)e.getValue()).getEnergyStorage().getMaxCapacity())).takeWhile(e -> inserted.get() < amount).forEach(e -> inserted.addAndGet(this.insertInto(from, (Map.Entry<ElectricalConnectorBlockEntity, BotariumEnergyBlock<?>>)e, context, Math.min(perConsumer, amount - inserted.get()), simulate)));
        return inserted.get();
    }

    private long insertInto(ElectricalConnectorBlockEntity from, Map.Entry<ElectricalConnectorBlockEntity, BotariumEnergyBlock<?>> to, NetworkPathConductivityContext context, long amount, boolean simulate) {
        long inserted;
        NetworkPath path;
        long insertedThroughThisPath;
        for (inserted = 0L; (path = this.pathManager.findConductiblePath(from, to.getKey())) != null && inserted < amount; inserted += insertedThroughThisPath) {
            BotariumEnergyBlock<?> botariumEnergyBlock;
            long pathConductivity = context.calculatePathConductivity(path);
            insertedThroughThisPath = to.getValue().getEnergyStorage().insertEnergy(Math.min(pathConductivity, amount - inserted), simulate);
            if (insertedThroughThisPath == 0L) break;
            if (simulate || insertedThroughThisPath <= 0L || !((botariumEnergyBlock = to.getValue()) instanceof class_2586)) continue;
            class_2586 be = (class_2586)botariumEnergyBlock;
            be.method_5431();
            class_1937 class_19372 = be.method_10997();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_14128(be.method_11016());
            if (pathConductivity == 0L) continue;
            context.decreasePathConductivity(path, insertedThroughThisPath);
        }
        return inserted;
    }

    public void destroy() {
        ElectricalNetworkTicker.removeNetwork(this);
        for (ElectricalConnectorBlockEntity node : this.nodes) {
            node.setNetwork(new ElectricalNetwork(node));
        }
    }

    protected void tick() {
        this.pathManager.tick();
    }

    public class_1937 getWorld() {
        return this.nodes.get(0).method_10997();
    }

    public List<ElectricalConnectorBlockEntity> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }
}

