/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.energiser;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.antarcticgardens.newage.content.energiser.EnergiserBehaviour;
import org.antarcticgardens.newage.content.energiser.EnergiserBlock;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class EnergiserBlockEntity
extends KineticBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    public WrappedBlockEnergyContainer energy;
    public int tier;
    public float size = 0.0f;
    private EnergiserBehaviour energisingBehaviour;
    public long lastCharged = -1L;

    public EnergiserBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int tier) {
        super(type, pos, state);
        this.energy = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new SimpleEnergyContainer(EnergiserBlock.getCapacity(tier)));
        this.tier = tier;
        this.energisingBehaviour.tier = tier;
    }

    protected class_238 createRenderBoundingBox() {
        class_243 pos = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        return new class_238(pos.method_1031(-1.0, -3.0, -1.0), pos.method_1031(1.0, 1.0, 1.0));
    }

    public static EnergiserBlockEntity newTier1(class_2591<?> type, class_2338 pos, class_2680 state) {
        return new EnergiserBlockEntity(type, pos, state, 1);
    }

    public static EnergiserBlockEntity newTier2(class_2591<?> type, class_2338 pos, class_2680 state) {
        return new EnergiserBlockEntity(type, pos, state, 2);
    }

    public static EnergiserBlockEntity newTier3(class_2591<?> type, class_2338 pos, class_2680 state) {
        return new EnergiserBlockEntity(type, pos, state, 3);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.energisingBehaviour = new EnergiserBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.energisingBehaviour);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(class_124.field_1068).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getStoredEnergy()), StringFormattingTool.formatLong(this.energy.getMaxCapacity())}).style(class_124.field_1075).forGoggles(tooltip, 1);
        if (this.lastCharged != -1L) {
            Lang.translate((String)"tooltip.create_new_age.energy_usage", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            Lang.translate((String)"tooltip.create_new_age.energy_per_second", (Object[])new Object[]{StringFormattingTool.formatLong(this.lastCharged * 20L)}).style(class_124.field_1075).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        return this.energy;
    }
}

