/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import team.reborn.energy.api.EnergyStorage;

public class FabricItemEnergyContainer
extends SnapshotParticipant<class_2487>
implements EnergyStorage {
    private final ContainerItemContext ctx;
    private final EnergyContainer container;

    public FabricItemEnergyContainer(ContainerItemContext ctx, EnergyContainer container) {
        this.ctx = ctx;
        class_2487 nbt = ctx.getItemVariant().getNbt();
        if (nbt != null) {
            container.deserialize(nbt);
        }
        this.container = container;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long inserted = this.container.insertEnergy(maxAmount, false);
        this.setChanged(transaction);
        return inserted;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long l = this.container.extractEnergy(maxAmount, false);
        this.setChanged(transaction);
        return l;
    }

    public long getAmount() {
        return this.container.getStoredEnergy();
    }

    public long getCapacity() {
        return this.container.getMaxCapacity();
    }

    public void setChanged(TransactionContext transaction) {
        class_1799 stack = this.ctx.getItemVariant().toStack();
        this.container.serialize(stack.method_7948());
        this.ctx.exchange(ItemVariant.of((class_1799)stack), this.ctx.getAmount(), transaction);
    }

    protected class_2487 createSnapshot() {
        return this.container.serialize(new class_2487());
    }

    protected void readSnapshot(class_2487 snapshot) {
        this.container.deserialize(snapshot);
    }
}

