/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.holder.ManualSyncing;
import earth.terrarium.botarium.fabric.fluid.holder.WrappedFluidHolder;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2586;

public class FabricBlockFluidContainer
extends ExtendedFluidContainer
implements Storage<FluidVariant>,
ManualSyncing {
    private final FluidContainer container;
    private final Updatable<class_2586> blockEntity;
    private final class_2586 block;

    public FabricBlockFluidContainer(FluidContainer container, Updatable<class_2586> updatable, class_2586 entity) {
        this.container = container;
        this.blockEntity = updatable;
        this.block = entity;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        List<FluidHolder> fluids = this.container.getFluids();
        return IntStream.range(0, fluids.size()).mapToObj(index -> new WrappedFluidHolder(this, (FluidHolder)fluids.get(index), this.container::extractFromSlot, this.container.getTankCapacity(index))).map(holder -> holder).iterator();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        this.blockEntity.update(this.block);
    }
}

