/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.item;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.item.SerializableContainer;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SimpleItemContainer
implements SerializableContainer {
    private final NonNullList<ItemStack> items;
    private final Updatable updatable;
    private final Predicate<Player> canPlayerAccess;

    public SimpleItemContainer(Updatable entity, int size, Predicate<Player> canPlayerAccess) {
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.updatable = entity;
        this.canPlayerAccess = canPlayerAccess;
    }

    public <T extends BlockEntity> SimpleItemContainer(T entity, int size) {
        this((Updatable)entity, size, player -> entity.m_58899_().m_123331_((Vec3i)player.m_20183_()) <= 64.0);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        return ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(this.items, (int)i, (int)j);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.items, (int)i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
    }

    public void m_6596_() {
        this.updatable.update();
    }

    public boolean m_6542_(Player player) {
        return this.canPlayerAccess.test(player);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

