/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.fluid;

import earth.terrarium.botarium.api.fluid.FluidHolder;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ForgeFluidHolder
implements FluidHolder {
    protected FluidStack fluidStack;

    public ForgeFluidHolder(FluidStack stack) {
        this.fluidStack = stack.copy();
    }

    public ForgeFluidHolder(FluidHolder fluid) {
        this(ForgeFluidHolder.toStack(fluid));
    }

    public ForgeFluidHolder(Fluid fluid, int amount, CompoundTag tag) {
        this.fluidStack = new FluidStack(fluid, amount, tag);
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public static ForgeFluidHolder fromCompound(CompoundTag compound) {
        Fluid fluid = (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(compound.m_128461_("Fluid")));
        int amount = (int)compound.m_128454_("Amount");
        CompoundTag nbt = null;
        if (compound.m_128441_("Nbt")) {
            nbt = compound.m_128469_("Nbt");
        }
        return new ForgeFluidHolder(fluid, amount, nbt);
    }

    @Override
    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.fluidStack = new FluidStack(fluid, this.fluidStack.getAmount(), this.fluidStack.getTag());
    }

    @Override
    public long getFluidAmount() {
        return this.fluidStack.getAmount();
    }

    @Override
    public void setAmount(long amount) {
        this.fluidStack = new FluidStack(this.fluidStack.getFluid(), (int)amount, this.fluidStack.getTag());
    }

    @Override
    public CompoundTag getCompound() {
        return this.fluidStack.getTag();
    }

    @Override
    public void setCompound(CompoundTag tag) {
        this.fluidStack.setTag(tag);
    }

    @Override
    public boolean matches(FluidHolder fluidHolder) {
        return this.getFluid().m_6212_(fluidHolder.getFluid()) && Objects.equals(fluidHolder.getCompound(), this.getCompound());
    }

    @Override
    public FluidHolder copyHolder() {
        return new ForgeFluidHolder(this.getFluid(), this.fluidStack.getAmount(), this.getCompound() == null ? null : this.getCompound().m_6426_());
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("Fluid", Registry.f_122822_.m_7981_((Object)this.getFluid()).toString());
        compoundTag.m_128356_("Amount", this.getFluidAmount());
        if (this.getCompound() != null) {
            compoundTag.m_128365_("Nbt", (Tag)this.getCompound());
        }
        return compoundTag;
    }

    @Override
    public void deserialize(CompoundTag compound) {
        long amount = compound.m_128454_("Amount");
        CompoundTag tag = null;
        if (compound.m_128441_("Nbt")) {
            tag = compound.m_128469_("Nbt");
        }
        this.fluidStack = new FluidStack((Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(compound.m_128461_("Fluid"))), (int)amount, tag);
    }

    @Override
    public boolean isEmpty() {
        return this.fluidStack.isEmpty();
    }

    public static FluidStack toStack(FluidHolder holder) {
        return new FluidStack(holder.getFluid(), (int)holder.getFluidAmount(), holder.getCompound());
    }

    public static ForgeFluidHolder empty() {
        return new ForgeFluidHolder(FluidStack.EMPTY);
    }
}

