/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.energiser;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.content.energiser.EnergiserBehaviour;
import org.antarcticgardens.newage.energy.InsertOnlyResizableEnergyContainer;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class EnergiserBlockEntity
extends KineticBlockEntity
implements EnergyBlock {
    public int tier;
    public float size = 0.0f;
    private EnergiserBehaviour energisingBehaviour;
    private InsertOnlyResizableEnergyContainer energy;
    public long lastCharged = -1L;

    public EnergiserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int tier) {
        super(type, pos, state);
        this.tier = tier;
        this.energisingBehaviour.tier = tier;
        if (this.energy == null) {
            this.getOrCreateNetwork();
        }
        this.energy.setMaxCapacity((long)(Math.pow(10.0, tier) * 1000.0));
    }

    protected AABB createRenderBoundingBox() {
        Vec3 pos = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        return new AABB(pos.m_82520_(-1.0, -3.0, -1.0), pos.m_82520_(1.0, 1.0, 1.0));
    }

    public static EnergiserBlockEntity newTier1(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new EnergiserBlockEntity(type, pos, state, 1);
    }

    public static EnergiserBlockEntity newTier2(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new EnergiserBlockEntity(type, pos, state, 2);
    }

    public static EnergiserBlockEntity newTier3(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new EnergiserBlockEntity(type, pos, state, 3);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.energisingBehaviour = new EnergiserBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.energisingBehaviour);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getStoredEnergy()), StringFormattingTool.formatLong(this.energy.getMaxCapacity())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        if (this.lastCharged != -1L) {
            Lang.translate((String)"tooltip.create_new_age.energy_usage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.translate((String)"tooltip.create_new_age.energy_per_second", (Object[])new Object[]{StringFormattingTool.formatLong(this.lastCharged * 20L)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public InsertOnlyResizableEnergyContainer getEnergyStorage() {
        if (this.energy == null) {
            this.energy = new InsertOnlyResizableEnergyContainer((Updatable)this, 0L);
        }
        return this.energy;
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

