/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.generation.carbonbrushes;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.generation.generatorcoil.GeneratorCoilBlock;
import org.antarcticgardens.newage.content.generation.generatorcoil.GeneratorCoilBlockEntity;
import org.antarcticgardens.newage.energy.ExtractOnlyResizableEnergyContainer;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class CarbonBrushesBlockEntity
extends KineticBlockEntity
implements EnergyBlock,
IHaveGoggleInformation {
    private ExtractOnlyResizableEnergyContainer energyContainer;
    private int lastOutput = 0;
    private int syncOut = 0;

    public CarbonBrushesBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("lastOutput", this.lastOutput);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lastOutput = compound.m_128451_("lastOutput");
        super.read(compound, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_output", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_per_second", (Object[])new Object[]{StringFormattingTool.formatLong((long)this.lastOutput * 20L)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        this.energyContainer.setMaxCapacity((long)this.lastOutput * 20L);
        int coilsLeft = (Integer)NewAgeConfig.getCommon().maxCoils.get();
        this.lastOutput = 0;
        coilsLeft = this.processCoil(this.f_58858_, facing, coilsLeft);
        this.processCoil(this.f_58858_, facing.m_122424_(), coilsLeft);
        EnergyHooks.distributeEnergyNearby((BlockEntity)this, (long)this.getEnergyStorage().getStoredEnergy());
    }

    public void lazyTick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.syncOut > 0) {
            this.syncOut = 0;
            this.m_6596_();
            this.sendData();
        }
    }

    private int processCoil(BlockPos pos, Direction dir, int left) {
        GeneratorCoilBlockEntity coil;
        if (left <= 0) {
            return 0;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos = pos.m_121945_(dir));
        if (blockEntity instanceof GeneratorCoilBlockEntity && ((Direction.Axis)(coil = (GeneratorCoilBlockEntity)blockEntity).m_58900_().m_61143_((Property)GeneratorCoilBlock.AXIS)).test(dir)) {
            int energy = coil.takeGeneratedEnergy();
            this.lastOutput += energy;
            this.syncOut += energy;
            this.getEnergyStorage().internalInsert(energy, false);
            return this.processCoil(pos, dir, left - 1);
        }
        return left;
    }

    public ExtractOnlyResizableEnergyContainer getEnergyStorage() {
        if (this.energyContainer == null) {
            this.energyContainer = new ExtractOnlyResizableEnergyContainer((Updatable)this, 0L);
        }
        return this.energyContainer;
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

