/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.stirlingengine;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class StirlingEngineBlockEntity
extends GeneratingKineticBlockEntity
implements HeatBlockEntity {
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;
    private float heat = 0.0f;
    public float speed = 0.0f;

    public StirlingEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("heat", this.heat);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(this.heat)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.using", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.temperature.ps", (Object[])new Object[]{StringFormattingTool.formatFloat(this.speed * 6.25f)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
        this.heat = compound.m_128457_("heat");
    }

    public float getGeneratedSpeed() {
        return this.speed;
    }

    public void tick() {
        super.tick();
        if (this.m_58904_() == null) {
            return;
        }
        if (this.m_58904_().m_46467_() % 20L == 0L) {
            HeatBlockEntity.transferAround(this);
            if (this.getHeat() > 50.0f) {
                if (this.getHeat() > 100.0f) {
                    double multiplier = (Double)NewAgeConfig.getCommon().overheatingMultiplier.get();
                    if ((double)this.getHeat() < 6000.0 * (Double)NewAgeConfig.getCommon().overheatingMultiplier.get()) {
                        this.setHeat(this.getHeat() - 100.0f);
                        if (this.speed != 16.0f) {
                            this.speed = 16.0f;
                            this.updateGeneratedRotation();
                        }
                    } else if (multiplier > 0.0) {
                        this.m_58904_().m_7731_(this.m_58899_(), Blocks.f_49991_.m_49966_(), 3);
                    }
                } else {
                    this.setHeat(this.getHeat() - 50.0f);
                    if (this.speed != 8.0f) {
                        this.speed = 8.0f;
                        this.updateGeneratedRotation();
                    }
                }
            } else if (this.speed != 0.0f) {
                this.speed = 0.0f;
                this.updateGeneratedRotation();
            }
        }
        if (!this.m_58904_().f_46443_) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public boolean canConnect(Direction from) {
        return from == Direction.UP;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.m_6596_();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.m_6596_();
    }
}

