/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.motors.MotorScrollValueBehaviour;
import org.antarcticgardens.newage.energy.InsertOnlyResizableEnergyContainer;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class MotorBlockEntity
extends GeneratingKineticBlockEntity
implements EnergyBlock,
IHaveGoggleInformation {
    public boolean needsPower = false;
    private final long maxCapacity;
    private final float stressImpact;
    private final float maxSpeed;
    public MotorScrollValueBehaviour speedBehavior;
    public boolean powered = false;
    private float actualSpeed = 0.0f;
    private float actualStress = 0.0f;
    private long prvEnergy = -100000L;
    private int energySpam = 0;
    private float speed = 0.0f;
    private float stress = 0.0f;
    private InsertOnlyResizableEnergyContainer energy;
    private long e;

    public MotorBlockEntity(BlockEntityType<?> arg, BlockPos arg2, BlockState arg3, long maxCapacity, float stressImpact, float maxSpeed) {
        super(arg, arg2, arg3);
        this.maxCapacity = maxCapacity;
        this.stressImpact = stressImpact;
        this.maxSpeed = maxSpeed;
        if (this.energy == null) {
            this.getOrCreateNetwork();
        }
        this.energy.setMaxCapacity(maxCapacity);
        this.speedBehavior.between((int)(-maxSpeed), (int)maxSpeed);
    }

    public static BlockEntityBuilder.BlockEntityFactory<MotorBlockEntity> create(long capacity, float stressGenerated, float maxSpeed) {
        return (type, pos, state) -> new MotorBlockEntity(type, pos, state, capacity, stressGenerated, maxSpeed);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.speedBehavior = new MotorScrollValueBehaviour((Component)Lang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.speedBehavior.requiresWrench();
        this.speedBehavior.value = this.getDefaultSpeed();
        this.speedBehavior.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.speedBehavior);
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public int getDefaultSpeed() {
        return 16;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.energy.setEnergy(compound.m_128454_("energy"));
        this.actualSpeed = compound.m_128457_("aSpeed");
        this.needsPower = compound.m_128471_("needsPower");
        this.stress = compound.m_128457_("lastGeneratedStress");
        this.speed = compound.m_128457_("lastGeneratedSpeed");
        this.e = compound.m_128454_("eUse");
        super.read(compound, clientPacket);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128356_("energy", this.energy.getStoredEnergy());
        compound.m_128350_("aSpeed", this.actualSpeed);
        compound.m_128379_("needsPower", this.needsPower);
        compound.m_128350_("lastGeneratedStress", this.stress);
        compound.m_128350_("lastGeneratedSpeed", this.speed);
        compound.m_128350_("eUse", (float)this.e);
        super.write(compound, clientPacket);
    }

    public float calculateStressApplied() {
        return 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getStoredEnergy()), StringFormattingTool.formatLong(this.energy.getMaxCapacity())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.using", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.energy_per_second", (Object[])new Object[]{StringFormattingTool.formatLong(this.e * 20L)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public float calculateAddedStressCapacity() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return this.lastCapacityProvided;
        }
        this.lastCapacityProvided = this.actualStress / this.actualSpeed;
        this.lastCapacityProvided = Float.isNaN(this.lastCapacityProvided) || Float.isInfinite(this.lastCapacityProvided) ? 0.0f : Math.abs(this.lastCapacityProvided);
        return this.lastCapacityProvided;
    }

    public float getGeneratedSpeed() {
        return this.actualSpeed;
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            network.updateCapacityFor((KineticBlockEntity)this, this.stress);
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_()) {
            int needed = (int)Math.ceil((double)this.stressImpact * (Double)NewAgeConfig.getCommon().suToEnergy.get());
            long l = this.e = this.needsPower == this.powered ? this.energy.internalExtract(needed, false) : 0L;
            if (this.e > 0L) {
                this.actualSpeed = this.speedBehavior.value;
                this.actualStress = (float)Math.ceil(this.stressImpact * ((float)this.e / (float)needed));
            } else {
                this.actualSpeed = 0.0f;
                this.actualStress = 0.0f;
            }
            if (this.actualSpeed != this.speed || this.actualStress != this.stress) {
                this.updateGeneratedRotation();
                this.speed = this.actualSpeed;
                this.stress = this.actualStress;
            } else if (this.energy.getStoredEnergy() != this.prvEnergy && this.energySpam > 10) {
                this.sendData();
                this.prvEnergy = this.energy.getStoredEnergy();
                this.energySpam = 0;
            }
        }
        ++this.energySpam;
    }

    public InsertOnlyResizableEnergyContainer getEnergyStorage() {
        if (this.energy == null) {
            this.energy = new InsertOnlyResizableEnergyContainer((Updatable)this, this.maxCapacity);
        }
        return this.energy;
    }

    static class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            return super.getLocalOffset(state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.cast((PoseStack)ms).rotateZ((double)(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f));
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

