/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.reactor;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.tools.RaycastUtil;

public class NuclearUtil {
    public static final TagKey<Block> STOPS_RADIATION = BlockTags.create((ResourceLocation)new ResourceLocation("create_new_age", "stops_radiation"));
    public static final TagKey<Item> HAZMAT_SUIT = ItemTags.create((ResourceLocation)new ResourceLocation("create_new_age", "nuclear/hazmat_suit"));

    public static void createRadiation(int length, Level world, BlockPos pos) {
        if (world.m_5776_()) {
            return;
        }
        List entities = world.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), new AABB(pos).m_82400_((double)length), livingEntity -> !NuclearUtil.isResistant((Entity)livingEntity));
        block0: for (LivingEntity le : entities) {
            for (Direction dir : Direction.values()) {
                BlockHitResult bhr;
                Vec3 direction;
                HitResult hitResult;
                if (world.m_8055_(pos.m_121945_(dir)).m_204336_(STOPS_RADIATION)) continue;
                Vec3 start = Vec3.m_82512_((Vec3i)pos).m_231075_(dir, 0.5);
                double distance = le.m_146892_().m_82554_(start);
                if (distance > (double)length || (hitResult = RaycastUtil.pickFilteredBlockFromPos(world, start, direction = le.m_146892_().m_82546_(start).m_82541_(), (float)Math.ceil(distance), bs -> bs.m_204336_(STOPS_RADIATION))) instanceof BlockHitResult && (world.m_8055_((bhr = (BlockHitResult)hitResult).m_82425_()).m_204336_(STOPS_RADIATION) || bhr.m_82450_().m_82554_(start) < distance)) continue;
                NuclearUtil.irradiate(le);
                continue block0;
            }
        }
    }

    private static boolean isResistant(Entity entity) {
        Player pl;
        if (entity instanceof Player && (pl = (Player)entity).m_7500_()) {
            return true;
        }
        for (ItemStack piece : entity.m_6168_()) {
            if (piece.m_204117_(HAZMAT_SUIT)) continue;
            return false;
        }
        return true;
    }

    private static void irradiate(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 400, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 300, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 1));
    }
}

