/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.energy;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.ExtractOnlyEnergyContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class ExtractOnlyResizableEnergyContainer
extends ExtractOnlyEnergyContainer
implements Updatable {
    private long capacity;
    private long energy;

    public ExtractOnlyResizableEnergyContainer(Updatable entity, long capacity) {
        super(entity, capacity);
        this.capacity = capacity;
    }

    public long insertEnergy(long maxAmount, boolean simulate) {
        return 0L;
    }

    public long extractEnergy(long maxAmount, boolean simulate) {
        return this.internalExtract(maxAmount, simulate);
    }

    public long internalInsert(long maxAmount, boolean simulate) {
        long inserted = Mth.m_14053_((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    public long internalExtract(long maxAmount, boolean simulate) {
        long extracted = Mth.m_14053_((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
    }

    public long getStoredEnergy() {
        return this.energy;
    }

    public void setMaxCapacity(long capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public long getMaxCapacity() {
        return this.capacity;
    }

    public long maxInsert() {
        return 1024L;
    }

    public long maxExtract() {
        return 1024L;
    }

    public CompoundTag serialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        tag.m_128356_("Energy", this.energy);
        root.m_128365_("BotariumData", (Tag)tag);
        return root;
    }

    public void deserialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        this.energy = tag.m_128454_("Energy");
    }

    public boolean allowsInsertion() {
        return false;
    }

    public boolean allowsExtraction() {
        return true;
    }

    public void update() {
        this.updatable.update();
    }
}

