/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.energy;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class InsertOnlyResizableEnergyContainer
extends InsertOnlyEnergyContainer {
    private long capacity;
    private long energy;

    public InsertOnlyResizableEnergyContainer(Updatable entity, long maxCapacity) {
        super(entity, maxCapacity);
        this.capacity = maxCapacity;
    }

    public long insertEnergy(long maxAmount, boolean simulate) {
        return this.internalInsert(maxAmount, simulate);
    }

    public long extractEnergy(long maxAmount, boolean simulate) {
        return 0L;
    }

    public long internalInsert(long maxAmount, boolean simulate) {
        long inserted = Mth.m_14053_((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    public long internalExtract(long maxAmount, boolean simulate) {
        long extracted = Mth.m_14053_((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
    }

    public long getStoredEnergy() {
        return this.energy;
    }

    public void setMaxCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getMaxCapacity() {
        return this.capacity;
    }

    public long maxInsert() {
        return 1024L;
    }

    public long maxExtract() {
        return 1024L;
    }

    public CompoundTag serialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        tag.m_128356_("Energy", this.energy);
        root.m_128365_("BotariumData", (Tag)tag);
        return root;
    }

    public void deserialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        this.energy = tag.m_128454_("Energy");
    }

    public boolean allowsInsertion() {
        return true;
    }

    public boolean allowsExtraction() {
        return false;
    }
}

